/***************************************************************************
    qgsclassificationwidgetwrapper.h
     --------------------------------------
    Date                 : 5.1.2014
    Copyright            : (C) 2014 Matthias Kuhn
    Email                : matthias at opengis dot ch
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSCLASSIFICATIONWIDGETWRAPPER_H
#define QGSCLASSIFICATIONWIDGETWRAPPER_H

#include "qgis_gui.h"
#include "qgseditorwidgetwrapper.h"

#include <QComboBox>

SIP_NO_FILE

/**
 * \ingroup gui
 * \class QgsClassificationWidgetWrapper
 * \brief A widget wrapper for classification widgets.
 * \note not available in Python bindings
 */
class GUI_EXPORT QgsClassificationWidgetWrapper : public QgsEditorWidgetWrapper
{
    Q_OBJECT
  public:
    /**
     * Constructor for QgsClassificationWidgetWrapper.
     *
     * The \a layer and \a fieldIdx arguments specify the vector layer field associated with the wrapper.
     *
     * The \a editor argument indicates the editor widget to use with the wrapper. This can be NULLPTR if a
     * new widget should be autogenerated.
     *
     * A \a parent widget for this widget wrapper and the created widget can also be specified.
     */
    explicit QgsClassificationWidgetWrapper( QgsVectorLayer *layer, int fieldIdx, QWidget *editor = nullptr, QWidget *parent = nullptr );

    // QgsEditorWidgetWrapper interface
  public:
    QVariant value() const override;
    void showIndeterminateState() override;

  protected:
    QWidget *createWidget( QWidget *parent ) override;
    void initWidget( QWidget *editor ) override;
    bool valid() const override;

  private:
    void updateValues( const QVariant &value, const QVariantList & = QVariantList() ) override;

    QComboBox *mComboBox = nullptr;
};

#endif // QGSCLASSIFICATIONWIDGETWRAPPER_H
