/***************************************************************************
    qgsgeometryanglecheck.h
    ---------------------
    begin                : September 2014
    copyright            : (C) 2015 by Sandro Mani / Sourcepole AG
    email                : smani at sourcepole dot ch
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define SIP_NO_FILE

#ifndef QGS_GEOMETRY_ANGLE_CHECK_H
#define QGS_GEOMETRY_ANGLE_CHECK_H

#include "qgsgeometrycheck.h"

#include <QString>

using namespace Qt::StringLiterals;

/**
 * \ingroup analysis
 * \brief Angle check.
 */
class ANALYSIS_EXPORT QgsGeometryAngleCheck : public QgsGeometryCheck
{
    Q_DECLARE_TR_FUNCTIONS( QgsGeometryAngleCheck )
  public:
    enum ResolutionMethod
    {
      DeleteNode,
      NoChange
    };

    QgsGeometryAngleCheck( QgsGeometryCheckContext *context, const QVariantMap &configuration )
      : QgsGeometryCheck( context, configuration )
      , mMinAngle( configuration.value( u"minAngle"_s, 0.0 ).toDouble() )
    {}

    QgsGeometryCheck::Result collectErrors( const QMap<QString, QgsFeaturePool *> &featurePools, QList<QgsGeometryCheckError *> &errors, QStringList &messages, QgsFeedback *feedback, const LayerFeatureIds &ids = LayerFeatureIds() ) const override;
    void fixError( const QMap<QString, QgsFeaturePool *> &featurePools, QgsGeometryCheckError *error, int method, const QMap<QString, int> &mergeAttributeIndices, Changes &changes ) const override;

    QList<Qgis::GeometryType> compatibleGeometryTypes() const override;
    Q_DECL_DEPRECATED QStringList resolutionMethods() const override;
    QString id() const override;
    QString description() const override;
    QgsGeometryCheck::CheckType checkType() const override;

    static QList<Qgis::GeometryType> factoryCompatibleGeometryTypes() SIP_SKIP;
    static bool factoryIsCompatible( QgsVectorLayer *layer ) SIP_SKIP;
    static QString factoryDescription() SIP_SKIP;
    static QString factoryId() SIP_SKIP;
    static QgsGeometryCheck::CheckType factoryCheckType() SIP_SKIP;

  private:
    double mMinAngle;
};

#endif // QGS_GEOMETRY_ANGLE_CHECK_H
