---
name: t.rast.colors.py
description: Creates/modifies the color table associated with each raster map of the space time raster dataset.
keywords: [ temporal, color table, raster, time ]
---

# t.rast.colors.py

Creates/modifies the color table associated with each raster map of the space time raster dataset.

=== "Command line"

    **t.rast.colors.py**
    [**-rwlngae**]
    **input**=*name*
    [**color**=*style*]
    [**raster**=*name*]
    [**raster_3d**=*name*]
    [**rules**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast.colors.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***t.rast.colors.py***",
        **input**,
        **color**=*None*,
        **raster**=*None*,
        **raster_3d**=*None*,
        **rules**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("t.rast.colors.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast_colors_py*(**input**,
        **color**=*None*,
        **raster**=*None*,
        **raster_3d**=*None*,
        **rules**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast_colors_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    **color**=*style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color table (see r.color help)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    **raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy color table  
    **raster_3d**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map from which to copy color table  
    **rules**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to rules file  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove existing color table  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only write new color table if it does not already exist  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List available rules then exit  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Invert colors  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Logarithmic scaling  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Logarithmic-absolute scaling  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Histogram equalization  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color table (see r.color help)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, colortable, *style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    **raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster_3d** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map from which to copy color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **rules** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *w*, *l*, *n*, *g*, *a*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove existing color table  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only write new color table if it does not already exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available rules then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert colors  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logarithmic scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logarithmic-absolute scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Histogram equalization  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color table (see r.color help)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, colortable, *style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    **raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster_3d** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map from which to copy color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **rules** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *w*, *l*, *n*, *g*, *a*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove existing color table  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only write new color table if it does not already exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available rules then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert colors  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logarithmic scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logarithmic-absolute scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Histogram equalization  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.rast.colors* computes a color table based on all registered maps of a
space time raster dataset and to assign this color table to each map.
Hence the created color table reflects the data range of the space time
raster dataset. This module is a simple wrapper around
[r.colors](r.colors.md). All options of *r.colors* are supported.
Internally a file with map names is created and passed to the *file*
option of *r.colors*.

Please have a look at the [r.colors](r.colors.md) manual page for
further information.

## EXAMPLE

Set Celsius color table to monthly dataset

```sh
t.rast.colors input=tempmean_monthly color=celsius

r.colors.out map=2009_01_tempmean

-80 0:0:40
-40 91:10:168
-30 220:220:220
-25 91:50:128
-20 50:0:150
-15 4:25:130
-10 8:54:106
-8 4:20:150
-5 0:50:255
-2 8:10:118
-0.061449 8:113:155
0.013855 8:118:157
0.090594 8:123:158
0.168767 8:128:159
0.248375 8:133:159
0.329417 8:136:160
...
40.6976 183:163:163
41.0483 185:167:167
41.4004 188:170:171
41.754 190:174:174
42.109 191:178:178
42.4655 193:182:182
42.8233 195:185:185
43.1827 197:189:189
43.5434 199:192:193
43.9056 200:197:197
44.2692 202:200:201
44.6342 204:204:204
45.0007 206:206:206
80 155:10:155
nv 255:255:255
default 255:255:255
```

## SEE ALSO

*[r.colors](r.colors.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.rast.colors source code](https://github.com/OSGeo/grass/tree/main/temporal/t.rast.colors)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.rast.colors))  
Latest change: Monday Nov 03 07:16:48 2025 in commit [c967967](https://github.com/OSGeo/grass/commit/c96796774942e46bbababcd652d3986d4e295665)
