---
name: r.out.ppm3
description: Converts 3 GRASS raster layers (R,G,B) to a PPM image file.
keywords: [ raster, export, output ]
---

# r.out.ppm3

Converts 3 GRASS raster layers (R,G,B) to a PPM image file.

=== "Command line"

    **r.out.ppm3**
    [**-c**]
    **red**=*string*
    **green**=*string*
    **blue**=*string*
    **output**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.out.ppm3 red=string green=string blue=string output=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.out.ppm3***",
        **red**,
        **green**,
        **blue**,
        **output**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.out.ppm3", red="string", green="string", blue="string", output="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_out_ppm3*(**red**,
        **green**,
        **blue**,
        **output**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_out_ppm3(red="string", green="string", blue="string", output="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **red**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;red&gt;  
    **green**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;green&gt;  
    **blue**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;blue&gt;  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new PPM file. (use '-' for stdout)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Add comments to describe the region  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **red** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;red&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **green** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;green&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **blue** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;blue&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new PPM file. (use '-' for stdout)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add comments to describe the region  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **red** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;red&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **green** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;green&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **blue** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;blue&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new PPM file. (use '-' for stdout)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add comments to describe the region  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

**r.out.ppm3** converts 3 GRASS raster layers (R,G,B) to a PPM image
file, using the current region.

This program converts a GRASS raster map to a PPM image file using the
the current region settings.

To get the full area and resolution of the raster map, run:

```sh
g.region raster=[mapname]
```

before running *r.out.ppm3*.

## NOTES

One pixel is written for each cell value, so if ew_res and ns_res
differ, the aspect ratio of the resulting image will be off.

## SEE ALSO

*[r.out.ppm](r.out.ppm.md),* *[r.in.gdal](r.in.gdal.md),*
*[d.rgb](d.rgb.md)*

## AUTHOR

Glynn Clements  
Based upon *r.out.ppm* and *d.rgb*.

## SOURCE CODE

Available at: [r.out.ppm3 source code](https://github.com/OSGeo/grass/tree/main/raster/r.out.ppm3)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.out.ppm3))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
