---
name: i.zc
description: Zero-crossing "edge detection" raster function for image processing.
keywords: [ imagery, edges ]
---

# i.zc

Zero-crossing "edge detection" raster function for image processing.

=== "Command line"

    **i.zc**
    **input**=*string*
    **output**=*string*
    [**width**=*integer*]
    [**threshold**=*float*]
    [**orientations**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.zc input=string output=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.zc***",
        **input**,
        **output**,
        **width**=*9*,
        **threshold**=*1.0*,
        **orientations**=*1*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.zc", input="string", output="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_zc*(**input**,
        **output**,
        **width**=*9*,
        **threshold**=*1.0*,
        **orientations**=*1*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_zc(input="string", output="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Zero crossing raster map  
    **width**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;x-y extent of the Gaussian filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sensitivity of Gaussian filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **orientations**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of azimuth directions categorized  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Zero crossing raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;x-y extent of the Gaussian filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sensitivity of Gaussian filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **orientations** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of azimuth directions categorized  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Zero crossing raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;x-y extent of the Gaussian filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sensitivity of Gaussian filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **orientations** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of azimuth directions categorized  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.zc* is an image processing module used for edge detection. The raster
map produced shows the location of "boundaries" on the input map.
Boundaries tend to be found in regions of changing cell values and tend
to run perpendicular to the direction of the slope. The algorithm used
for edge detection is one of the "zero-crossing" algorithms and is
discussed briefly below.

## NOTES

The procedure to find the "edges" in the image is as follows:

1. The Fourier transform of the image is taken,
2. The Fourier transform of the Laplacian of a two-dimensional Gaussian
    function is used to filter the transformed image,
3. The result is run through an inverse Fourier transform,
4. The resulting image is traversed in search of places where the image
    changes from positive to negative or from negative to positive,
5. Each cell in the map where the value crosses zero (with a change in
    value greater than the threshold value) is marked as an edge and an
    orientation is assigned to it. The resulting raster map layer is
    output.

The **width=** parameter determines the x-y extent of the Gaussian
filter. The default value is **9**; higher and lower values can be
tested by the user. Increasing the width will result in finding "edges"
representing more gradual changes in cell values.

The **threshold=** parameter determines the "sensitivity" of the
Gaussian filter. The default value is **1**; higher and lower values can
be tested by the user. Increasing the threshold value will result in
fewer edges being found.

The **orientations=** value is the number of azimuth directions the
cells on the output raster map layer are categorized into (similar to
the aspect raster map layer produced by
*[r.slope.aspect](r.slope.aspect.md)*. For example, a value of **16**
would result in detected edges being categorized into one of 16 bins
depending on the direction of the edge at that point.

The current region definition and mask settings are respected when
reading the input map.

## SEE ALSO

*[i.fft](i.fft.md), [i.ifft](i.ifft.md), [r.mapcalc](r.mapcalc.md),
[r.mfilter](r.mfilter.md), [r.slope.aspect](r.slope.aspect.md)*

## AUTHOR

David Satnik, GIS Laboratory, Central Washington University

## SOURCE CODE

Available at: [i.zc source code](https://github.com/OSGeo/grass/tree/main/imagery/i.zc)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.zc))  
Latest change: Friday Jan 02 21:25:59 2026 in commit [83362df](https://github.com/OSGeo/grass/commit/83362df5af36c1e7d95fad93dff0a57b4dfde476)
