---
name: i.evapo.mh
description: Computes evapotranspiration calculation modified or original Hargreaves formulation, 2001.
keywords: [ imagery, evapotranspiration ]
---

# i.evapo.mh

Computes evapotranspiration calculation modified or original Hargreaves formulation, 2001.

=== "Command line"

    **i.evapo.mh**
    [**-zhs**]
    **netradiation_diurnal**=*name*
    **average_temperature**=*name*
    **minimum_temperature**=*name*
    **maximum_temperature**=*name*
    [**precipitation**=*name*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.evapo.mh netradiation_diurnal=name average_temperature=name minimum_temperature=name maximum_temperature=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.evapo.mh***",
        **netradiation_diurnal**,
        **average_temperature**,
        **minimum_temperature**,
        **maximum_temperature**,
        **precipitation**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.evapo.mh", netradiation_diurnal="name", average_temperature="name", minimum_temperature="name", maximum_temperature="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_evapo_mh*(**netradiation_diurnal**,
        **average_temperature**,
        **minimum_temperature**,
        **maximum_temperature**,
        **precipitation**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_evapo_mh(netradiation_diurnal="name", average_temperature="name", minimum_temperature="name", maximum_temperature="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **netradiation_diurnal**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input diurnal net radiation raster map [W/m2/d]  
    **average_temperature**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input average air temperature raster map [C]  
    **minimum_temperature**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input minimum air temperature raster map [C]  
    **maximum_temperature**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input maximum air temperature raster map [C]  
    **precipitation**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of precipitation raster map [mm/month]  
    &nbsp;&nbsp;&nbsp;&nbsp;Disabled for original Hargreaves (1985)  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map [mm/d]  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set negative ETa to zero  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use original Hargreaves (1985)  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use Hargreaves-Samani (1985)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **netradiation_diurnal** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input diurnal net radiation raster map [W/m2/d]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **average_temperature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input average air temperature raster map [C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **minimum_temperature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input minimum air temperature raster map [C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **maximum_temperature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input maximum air temperature raster map [C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **precipitation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of precipitation raster map [mm/month]  
    &nbsp;&nbsp;&nbsp;&nbsp;Disabled for original Hargreaves (1985)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map [mm/d]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*, *h*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set negative ETa to zero  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use original Hargreaves (1985)  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use Hargreaves-Samani (1985)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **netradiation_diurnal** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input diurnal net radiation raster map [W/m2/d]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **average_temperature** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input average air temperature raster map [C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **minimum_temperature** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input minimum air temperature raster map [C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **maximum_temperature** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input maximum air temperature raster map [C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **precipitation** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of precipitation raster map [mm/month]  
    &nbsp;&nbsp;&nbsp;&nbsp;Disabled for original Hargreaves (1985)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map [mm/d]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*, *h*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set negative ETa to zero  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use original Hargreaves (1985)  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use Hargreaves-Samani (1985)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.evapo.mh* calculates the reference evapotranspiration (ET) after
Hargreaves et al. (1985), Hargreaves and Samani (1985) and the Modified
Hargreaves version found in Droogers and Allen (2002).

## REFERENCES

- Hargreaves GL, Hargreaves GH, Riley JP, 1985. Agricultural benefits
  for Senegal River Basin. Journal of Irrigation and Drainange
  Engineering, ASCE, 111(2):113-124.
- Droogers P, Allen RG, 2002. Towards a simplified global reference
  evapotranspiration equation. Irrigation Science.
- Droogers, P., Allen RG. 2002. Estimating reference evapotranspiration
  under inaccurate data conditions. Irrigation and Drainage Systems 16:
  33-45.
- Hargreaves GH, Samani ZA, 1985. Reference crop evapotranspiration from
  ambient air temperature. American Society of Agricultural Engineers
  (Microfiche collection)(USA). no. fiche no. 85-2517.

## SEE ALSO

*[i.evapo.pt](i.evapo.pt.md), [i.evapo.pm](i.evapo.pm.md),
[i.evapo.time](i.evapo.time.md), [r.sun](r.sun.md)*

## AUTHOR

Yann Chemin, GRASS Development team, 2007-2016

## SOURCE CODE

Available at: [i.evapo.mh source code](https://github.com/OSGeo/grass/tree/main/imagery/i.evapo.mh)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.evapo.mh))  
Latest change: Thursday Jun 26 21:25:27 2025 in commit [3ec2b13](https://github.com/OSGeo/grass/commit/3ec2b13945d963db69544e3fc9339fbff72f33f3)
