---
name: i.eb.hsebal01
description: Computes sensible heat flux iteration SEBAL 01.
keywords: [ imagery, energy balance, soil moisture, evaporative fraction, SEBAL ]
---

# i.eb.hsebal01

Computes sensible heat flux iteration SEBAL 01.

=== "Command line"

    **i.eb.hsebal01**
    [**-ac**]
    **netradiation**=*name*
    **soilheatflux**=*name*
    **aerodynresistance**=*name*
    **temperaturemeansealevel**=*name*
    **vapourpressureactual**=*name*
    **frictionvelocitystar**=*float*
    [**row_wet_pixel**=*float*]
    [**column_wet_pixel**=*float*]
    [**row_dry_pixel**=*float*]
    [**column_dry_pixel**=*float*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.eb.hsebal01 netradiation=name soilheatflux=name aerodynresistance=name temperaturemeansealevel=name vapourpressureactual=name frictionvelocitystar=0.32407 output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.eb.hsebal01***",
        **netradiation**,
        **soilheatflux**,
        **aerodynresistance**,
        **temperaturemeansealevel**,
        **vapourpressureactual**,
        **frictionvelocitystar**=*0.32407*,
        **row_wet_pixel**=*None*,
        **column_wet_pixel**=*None*,
        **row_dry_pixel**=*None*,
        **column_dry_pixel**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.eb.hsebal01", netradiation="name", soilheatflux="name", aerodynresistance="name", temperaturemeansealevel="name", vapourpressureactual="name", frictionvelocitystar=0.32407, output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_eb_hsebal01*(**netradiation**,
        **soilheatflux**,
        **aerodynresistance**,
        **temperaturemeansealevel**,
        **vapourpressureactual**,
        **frictionvelocitystar**=*0.32407*,
        **row_wet_pixel**=*None*,
        **column_wet_pixel**=*None*,
        **row_dry_pixel**=*None*,
        **column_dry_pixel**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_eb_hsebal01(netradiation="name", soilheatflux="name", aerodynresistance="name", temperaturemeansealevel="name", vapourpressureactual="name", frictionvelocitystar=0.32407, output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **netradiation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of instantaneous net radiation raster map [W/m2]  
    **soilheatflux**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of instantaneous soil heat flux raster map [W/m2]  
    **aerodynresistance**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of aerodynamic resistance to heat momentum raster map [s/m]  
    **temperaturemeansealevel**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of altitude corrected surface temperature raster map [K]  
    **vapourpressureactual**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the actual vapour pressure (e_act) map [KPa]  
    **frictionvelocitystar**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the height independent friction velocity (u\*) [m/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.32407*  
    **row_wet_pixel**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Row value of the wet pixel  
    **column_wet_pixel**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column value of the wet pixel  
    **row_dry_pixel**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Row value of the dry pixel  
    **column_dry_pixel**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column value of the dry pixel  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output sensible heat flux raster map [W/m2]  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatic wet/dry pixel (careful!)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Dry/Wet pixels coordinates are in image projection, not row/col  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **netradiation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of instantaneous net radiation raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **soilheatflux** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of instantaneous soil heat flux raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **aerodynresistance** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of aerodynamic resistance to heat momentum raster map [s/m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **temperaturemeansealevel** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of altitude corrected surface temperature raster map [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **vapourpressureactual** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the actual vapour pressure (e_act) map [KPa]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **frictionvelocitystar** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the height independent friction velocity (u\*) [m/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.32407*  
    **row_wet_pixel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Row value of the wet pixel  
    **column_wet_pixel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column value of the wet pixel  
    **row_dry_pixel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Row value of the dry pixel  
    **column_dry_pixel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column value of the dry pixel  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output sensible heat flux raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Automatic wet/dry pixel (careful!)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dry/Wet pixels coordinates are in image projection, not row/col  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **netradiation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of instantaneous net radiation raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **soilheatflux** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of instantaneous soil heat flux raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **aerodynresistance** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of aerodynamic resistance to heat momentum raster map [s/m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **temperaturemeansealevel** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of altitude corrected surface temperature raster map [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **vapourpressureactual** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the actual vapour pressure (e_act) map [KPa]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **frictionvelocitystar** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the height independent friction velocity (u\*) [m/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.32407*  
    **row_wet_pixel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Row value of the wet pixel  
    **column_wet_pixel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column value of the wet pixel  
    **row_dry_pixel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Row value of the dry pixel  
    **column_dry_pixel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column value of the dry pixel  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output sensible heat flux raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Automatic wet/dry pixel (careful!)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dry/Wet pixels coordinates are in image projection, not row/col  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.eb.hsebal01* will calculate the sensible heat flux map (h0), given
both maps of Net Radiation and soil Heat flux (Rn, g0) at instantaneous
time, the surface roughness (z0m), a map of the altitude corrected
temperature (t0dem), a point data of the frictional velocity (u\*), a
value of actual vapour pressure (ea\[KPa\]) and the (x,y) pairs for wet
and dry pixels. Full process will need those:

- *i.vi*, *i.albedo*, *r.latlong*, *i.emissivity*
- *i.evapo.potrad* (GRASS Addon)
- *i.eb.netrad*, *i.eb.soilheatflux*, *i.eb.hsebal01*
- *i.eb.evapfr*, *i.eb.eta*

(for time integration: *i.evapo.time_integration*)

*i.eb.hsebal01* performs the computation of *sensible heat flux*
\[W/m2\] after Bastiaanssen, 1995 in \[1\], used in this form in 2001 by
\[2\]. Implemented in this code in \[3\].

## NOTES

- z0m can be alculated by *i.eb.z0m* or *i.eb.z0m0* (GRASS Addons).
- ea can be calculated with standard meteorological data.  
  eoTmin=0.6108\*EXP(17.27\*Tmin/(Tmin+237.3))  
  eoTmax=0.6108\*EXP(17.27\*Tmax/(Tmax+237.3))  
  ea=(RH/100)/((eoTmin+eoTmax)/2)
- t0dem = surface temperature + (altitude \* 0.627 / 100)

## REFERENCES

\[1\] Bastiaanssen, W.G.M., 1995. Estimation of Land surface parameters
by remote sensing under clear-sky conditions. PhD thesis, Wageningen
University, Wageningen, The Netherlands.
([PDF](https://edepot.wur.nl/206553))

\[2\] Chemin Y., Alexandridis T.A., 2001. Improving spatial resolution
of ET seasonal for irrigated rice in Zhanghe, China. Asian Journal of
Geoinformatics. 5(1):3-11,2004.

\[3\] Alexandridis T.K., Cherif I., Chemin Y., Silleos N.G., Stavrinos
E., Zalidis G.C. Integrated methodology for estimating water use in
Mediterranean agricultural areas. Remote Sensing. 2009, 1, 445-465.
([PDF](https://doi.org/10.3390/rs1030445))

\[4\] Chemin, Y., 2012. A Distributed Benchmarking Framework for Actual
ET Models, in: Irmak, A. (Ed.), Evapotranspiration - Remote Sensing and
Modeling. InTech. ([PDF](https://www.intechopen.com/chapters/26115))

## SEE ALSO

*[i.eb.soilheatflux](i.eb.soilheatflux.md),
[i.eb.evapfr](i.eb.evapfr.md)*

## AUTHOR

Yann Chemin, International Rice Research Institute, Los Banos, The
Philippines.

Contact: [Yann Chemin](mailto:yann.chemin@gmail.com)

## SOURCE CODE

Available at: [i.eb.hsebal01 source code](https://github.com/OSGeo/grass/tree/main/imagery/i.eb.hsebal01)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.eb.hsebal01))  
Latest change: Thursday Jul 10 08:15:30 2025 in commit [221d8f7](https://github.com/OSGeo/grass/commit/221d8f7997f68cab15a84350d572e77b6e6bdc37)
