---
name: g.gui.rdigit
description: Interactive editing and digitizing of raster maps.
keywords: [ general, GUI, raster, editing, digitizer ]
title: g.gui.rdigit
description: wxGUI Raster Digitizer
index: wxGUI
keywords: [display, GUI, raster, editing, digitizer]
---

# g.gui.rdigit

Interactive editing and digitizing of raster maps.

=== "Command line"

    **g.gui.rdigit**
    [**create**=*name*]
    [**base**=*name*]
    [**type**=*string*]
    [**edit**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.gui.rdigit create=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.gui.rdigit***",
        **create**=*None*,
        **base**=*None*,
        **type**=*"CELL"*,
        **edit**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.gui.rdigit", create="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_gui_rdigit*(**create**=*None*,
        **base**=*None*,
        **type**=*"CELL"*,
        **edit**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_gui_rdigit(create="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **create**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of new raster map to create  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **base**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of base raster map  
    **type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *CELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    **edit**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing raster map to edit  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **create** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of new raster map to create  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **base** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of base raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *CELL*  
    **edit** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing raster map to edit  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **create** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of new raster map to create  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **base** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of base raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *CELL*  
    **edit** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing raster map to edit  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

**Raster Digitizer** is a simple tool to quickly draw lines, areas, and
circles and save these features in a raster map. It is accessible from
the Map Display toolbar (from the combo box on the right).

*Raster Digitizer* currently allows you to:

- draw polygons, lines and points
- set category value of the feature you are drawing
- set feature width (width of currently digitized line or diameter of a
  digitized point in map units)
- create a new raster from scratch or from an already existing raster
- undo edits and save edits before leaving the digitizer

The typical workflow includes these steps:

1. Set computational region as needed.
2. Switch to Raster Digitizer and select a map to create. Select either
    a new raster or create a new raster from existing raster, also
    select raster type (CELL, FCELL, DCELL)
3. Specify category value and width *before* drawing a feature
4. Specify digitizing tool (area, line, point)
5. Start digitizing and when you want to finish area or line, *use
    right click*
6. Change color of temporary overlay depending on your needs
7. Set different category and repeat
8. At any point you can use *Undo* or *Save*
9. If existing raster is used for the new raster, digitized areas will
    respect the color table, but you can always set different color
    table.

## NOTES

Raster Digitizer respects computational region including the currently
set resolution.

## EXAMPLES

In the following figures we start with elev_lid792_1m raster map in
North carolina sample dataset and digitize two buildings, one
rectangular and one with circular footprint. Both buildings have the
roof level at 130 m. We set the width when digitizing the point to 50
meters which results in the building having 50 m in diameter. When we
are done with digitizing, we save the result and explore cast shadows of
the buildings with [r.sun](r.sun.md) module:

```sh
g.region raster=elev_lid792_1m
# now create elev_edited raster by digitizing and save
r.slope.aspect elevation=elev_edited slope=slope aspect=aspect
r.sun elevation=elev_edited aspect=aspect slope=slope beam_rad=beam day=172 time=6
```

![Raster digitizer example step 1](wxGUI_rdigit_step1.png)
![Raster digitizer example step 2](wxGUI_rdigit_step2.png)
![Raster digitizer example step 3](wxGUI_rdigit_step3.png)
![Raster digitizer example step 4](wxGUI_rdigit_step4.png)
![Raster digitizer example step 5](wxGUI_rdigit_step5.png)  
*Figure: Steps to digitize new buildings on elev_lid792_1m raster map.*

## SEE ALSO

*[wxGUI](wxGUI.md), [wxGUI components](wxGUI.components.md),
[r.in.poly](r.in.poly.md) (backend of digitizer),
[g.gui.vdigit](g.gui.vdigit.md)*

## AUTHORS

Anna Petrasova, NCSU GeoForALL Laboratory  
Tomas Zigo (standalone module)

## SOURCE CODE

Available at: [g.gui.rdigit source code](https://github.com/OSGeo/grass/tree/main/gui/wxpython/rdigit)
([history](https://github.com/OSGeo/grass/commits/main/gui/wxpython/rdigit))  
Latest change: Wednesday Jan 28 08:16:26 2026 in commit [0a9db34](https://github.com/OSGeo/grass/commit/0a9db34657dc4900ba35d6476b890c13d118c669)
