---
name: g.gui.mapswipe
description: Interactively compares two maps by swiping a visibility bar.
keywords: [ general, GUI, display ]
title: g.gui.mapswipe
description: wxGUI Map Swipe
index: topic_GUI|GUI
---

# g.gui.mapswipe

Interactively compares two maps by swiping a visibility bar.

=== "Command line"

    **g.gui.mapswipe**
    [**first**=*name*]
    [**second**=*name*]
    [**mode**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.gui.mapswipe
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.gui.mapswipe***",
        **first**=*None*,
        **second**=*None*,
        **mode**=*"swipe"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.gui.mapswipe")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_gui_mapswipe*(**first**=*None*,
        **second**=*None*,
        **mode**=*"swipe"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_gui_mapswipe()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **first**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;First (top/right) raster map  
    **second**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Second (bottom/left) raster map  
    **mode**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;View mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *swipe, mirror*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *swipe*  
    &nbsp;&nbsp;&nbsp;&nbsp;**swipe**: swiping the upper map layer to show the map layer below   
    &nbsp;&nbsp;&nbsp;&nbsp;**mirror**: synchronized maps side by side  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **first** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;First (top/right) raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **second** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Second (bottom/left) raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **mode** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;View mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *swipe, mirror*  
    &nbsp;&nbsp;&nbsp;&nbsp;**swipe**: swiping the upper map layer to show the map layer below   
    &nbsp;&nbsp;&nbsp;&nbsp;**mirror**: synchronized maps side by side  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *swipe*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **first** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;First (top/right) raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **second** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Second (bottom/left) raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **mode** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;View mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *swipe, mirror*  
    &nbsp;&nbsp;&nbsp;&nbsp;**swipe**: swiping the upper map layer to show the map layer below   
    &nbsp;&nbsp;&nbsp;&nbsp;**mirror**: synchronized maps side by side  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *swipe*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The **Map Swipe** is a *[wxGUI](wxGUI.md)* component which allows the
user to interactively compare two raster maps of the same area by
revealing different parts of the raster maps. It is useful e.g. for
comparing raster maps from different time periods. Map Swipe can be
launched from the menu `File -> Map Swipe`.

Map Swipe allows you to:

- switch orientation of the swipe line (horizontal or vertical)
- zooming, panning
- automatically load maps when opening Map Swipe with two selected
  raster maps in Layer Manager
- compare 2 raster maps or load different combinations of raster and
  vector maps and set transparency (advanced mode)
- save display to graphics file
- display text labels with map names
- choose between 'swipe' mode (default) and 'mirror' mode (synchronized
  maps displayed side by side)
- change the appearance of cursor in 'mirror' mode (available in Map
  Swipe settings)

![Map swipe screenshot](mapswipe_tsunami.jpg)  
*Figure: Pre and post disaster images of the tsunami in Japan in 2011. The upper
MODIS image taken on February 26, 2011, shows the coastline under normal
conditions while the lower MODIS image on March 13, 2011, shows a clear
view of tsunami flooding along the coastline. Water, black and dark blue
in these false-color images, still covers the ground as much as five
kilometers (three miles) from the coast. Source: [Earth
Observatory/NASA](https://earthobservatory.nasa.gov/images/49634/tsunami-flooding-near-sendai-japan)*

## SEE ALSO

*[wxGUI](wxGUI.md), [wxGUI components](wxGUI.components.md)*

See also the user
[wiki](https://grasswiki.osgeo.org/wiki/WxGUI_Map_Swipe) page.

## AUTHOR

Anna Kratochvilova, [Czech Technical University in
Prague](https://www.cvut.cz), Czech Republic

## SOURCE CODE

Available at: [g.gui.mapswipe source code](https://github.com/OSGeo/grass/tree/main/gui/wxpython/mapswipe)
([history](https://github.com/OSGeo/grass/commits/main/gui/wxpython/mapswipe))  
Latest change: Wednesday Jan 28 08:16:26 2026 in commit [0a9db34](https://github.com/OSGeo/grass/commit/0a9db34657dc4900ba35d6476b890c13d118c669)
