---
name: d.colortable
description: Displays the color table associated with a raster map layer.
keywords: [ display, raster, color table ]
---

# d.colortable

Displays the color table associated with a raster map layer.

=== "Command line"

    **d.colortable**
    [**-n**]
    **map**=*name*
    [**color**=*name*]
    [**lines**=*integer*]
    [**columns**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.colortable map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.colortable***",
        **map**,
        **color**=*"white"*,
        **lines**=*None*,
        **columns**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.colortable", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_colortable*(**map**,
        **color**=*"white"*,
        **lines**=*None*,
        **columns**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_colortable(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map whose color table is to be displayed  
    **color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of lines separating the colors of the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **lines**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of lines to appear in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    **columns**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of columns to appear in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not draw a collar showing the NULL color in FP maps  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map whose color table is to be displayed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of lines separating the colors of the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **lines** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of lines to appear in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    **columns** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of columns to appear in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not draw a collar showing the NULL color in FP maps  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map whose color table is to be displayed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of lines separating the colors of the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **lines** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of lines to appear in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    **columns** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of columns to appear in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not draw a collar showing the NULL color in FP maps  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.colortable* is used to display the color table associated with a
raster map in the active frame on the graphics monitor. The **map** name
should be an available raster map in the user's current mapset search
path and location.

If the *values* of both **lines** and **columns** are not specified by
the user, *d.colortable* divides the active frame equally among the
number of categories present in the named raster map. If one option is
specified, the other is automatically set to accommodate all categories.
If both are specified, as many categories as possible are displayed.

If the user specifies the name of a map on the command line but does not
specify the values of other parameters, parameter default values will be
used. Alternately, if the user types simply *d.colortable* on the
command line without any program arguments, the program will prompt the
user for parameter settings using the standard GRASS parser interface.

## EXAMPLE

The user running the command:

```sh
d.colortable map=soils color=red lines=1 columns=3
```

would see the active graphics frame divided into three columns extending
the full frame height. The lines dividing the color table associated
with the *soils* map would be displayed in red. The user would see, at
most, only three of the colors from the *soils* color table displayed in
the active frame (because the user requested that this frame be divided
into three sections).

## NOTES

If the user wishes to display the entire color table associated with a
map, the user should either stipulate a number of lines (rows) and
columns (cols) sufficient to accommodate the number of categories in the
map's color table, or fail to assign values to one or both of **lines**
and/or **columns**. If the user runs *d.colortable* using the default
number of lines and columns (the full graphics frame), all categories
from the map's color table will be displayed. However, if the user
requests that the color table associated with a map which has 10 data
categories be displayed in a graphics frame with only 3 lines (rows) and
2 columns (a total of six cells), only six of the ten map categories
will be displayed.

The user should run *[d.erase](d.erase.md)* between runs of
*d.colortable* to avoid confusion.

## SEE ALSO

*[d.erase](d.erase.md), [d.legend](d.legend.md), [d.rast](d.rast.md)*

## AUTHOR

James Westervelt, U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [d.colortable source code](https://github.com/OSGeo/grass/tree/main/display/d.colortable)
([history](https://github.com/OSGeo/grass/commits/main/display/d.colortable))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
