---
name: v.sample
description: Samples a raster map at vector point locations.
keywords: [ vector, sampling, raster ]
---

# v.sample

Samples a raster map at vector point locations.

=== "Command line"

    **v.sample**
    **input**=*name*
    [**layer**=*string*]
    **column**=*name*
    **output**=*name*
    **raster**=*name*
    [**method**=*string*]
    [**zscale**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.sample input=name column=name output=name raster=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.sample***",
        **input**,
        **layer**=*"1"*,
        **column**,
        **output**,
        **raster**,
        **method**=*"nearest"*,
        **zscale**=*1.0*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.sample", input="name", column="name", output="name", raster="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_sample*(**input**,
        **layer**=*"1"*,
        **column**,
        **output**,
        **raster**,
        **method**=*"nearest"*,
        **zscale**=*1.0*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_sample(input="name", column="name", output="name", raster="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector point map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to use for comparison  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map to store differences  
    **raster**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be sampled  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling interpolation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: Nearest-neighbor interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: Bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: Bicubic interpolation  
    **zscale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for values read from raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampled values will be multiplied by this factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector point map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to use for comparison  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map to store differences  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **raster** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be sampled  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling interpolation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: Nearest-neighbor interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: Bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: Bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for values read from raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampled values will be multiplied by this factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector point map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to use for comparison  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map to store differences  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **raster** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be sampled  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling interpolation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: Nearest-neighbor interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: Bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: Bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for values read from raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampled values will be multiplied by this factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.sample* samples a GRASS raster map at the point locations in the
input file by either cubic convolution interpolation, bilinear
interpolation, or nearest neighbor sampling (default).

This program may be especially useful when sampling for cross validation
of interpolations whose output is a raster map.

## NOTES

The output points will have the easting and northing of the input
points. The input category value is used. The input attribute, raster
value and difference is written to output.

When NULL values are encountered for a cell, zero value is used instead.
In these cases, more acurrate results may be obtained by using the
default nearest neighbor comparisons.

This program may not work properly with lat-long data when the **-bc**
flags are used.

When interpolation is done (i.e., the **-bc** flags are used), values
are assumed to be located at the centroid of grid cells. Therefore,
current resolution settings are important.

## EXAMPLE

Comparison of "elev_ned_30m" and "elev_srtm_30m" North Carolina sample
dataset elevation models at random positions:

```sh
# set computational region:
 g.region raster=elev_srtm_30m -p
# generate random points:
 v.random output=random n=100
# add table with one column:
 v.db.addtable random col="elev_srtm30 double precision"
# transfer elevations at random points into table:
 v.what.rast map=random rast=elev_srtm_30m col=elev_srtm30
# verify:
 v.db.select random

# perform sampling on other elevation map:
 v.sample in=random col=elev_srtm30 rast=elev_ned_30m out=elev_samples

#verify:
 v.db.select elev_samples

#univariate statistics of differences between elevation maps:
 v.univar elev_samples column=diff type=point
```

## SEE ALSO

*[g.region](g.region.md), [v.random](v.random.md),
[v.what.rast](v.what.rast.md)* *Image Sampling Methods* - GRASS Tutorial
on *s.sample* (available as
[s.sample-tutorial.ps.gz](https://grass.osgeo.org/gdp/sites/))

## AUTHORS

[James Darrell McCauley](http://mccauley-usa.com/)  
when he was at: [Agricultural
Engineering](http://ABE.www.ecn.purdue.edu/ABE/) [Purdue
University](http://www.purdue.edu/)

Updated for GRASS 5.0 by Eric G. Miller  
Updated for GRASS 5.7 by Radim Blazek

## SOURCE CODE

Available at: [v.sample source code](https://github.com/OSGeo/grass/tree/main/vector/v.sample)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.sample))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
