---
name: r.transect
description: Outputs raster map layer values lying along user defined transect line(s).
keywords: [ raster, profile, transect ]
---

# r.transect

Outputs raster map layer values lying along user defined transect line(s).

=== "Command line"

    **r.transect**
    [**-g**]
    **map**=*name*
    **line**=*east,north,azimuth,distance* [,*east,north,azimuth,distance*,...]
    [**null_value**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.transect map=name line=east,north,azimuth,distance
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r.transect***",
        **map**,
        **line**,
        **null_value**=*"\*"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r.transect", map="name", line="east,north,azimuth,distance")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_transect*(**map**,
        **line**,
        **null_value**=*"\*"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_transect(map="name", line="east,north,azimuth,distance")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to be queried  
    **line**=*east,north,azimuth,distance* [,*east,north,azimuth,distance*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Transect definition  
    **null_value**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output easting and northing in first two columns of four column output  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **line** : list[tuple[str, str, str, str]] | tuple[str, str, str, str] | list[str] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transect definition  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *east,north,azimuth,distance*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output easting and northing in first two columns of four column output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **line** : list[tuple[str, str, str, str]] | tuple[str, str, str, str] | list[str] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transect definition  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *east,north,azimuth,distance*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output easting and northing in first two columns of four column output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.transect* outputs, in ASCII, the values in a raster map which lie
along one or more user-defined transect lines. The transects are
described by their starting coordinates, azimuth, and distance.

The **line** parameter is a definition of (each) transect line,
specified by the geographic coordinates of its starting point (*easting,
northing*), the angle and direction of its travel (*azimuth*), and its
distance (*distance*).

The *azimuth* is an angle, in degrees, measured to the east of north.
The *distance* is in map units (meters for a metered database, like
UTM).

The **null** parameter can optionally be set to change the character
string representing null values.

## NOTES

This program is a front-end to the *[r.profile](r.profile.md)* program.
It simply converts the azimuth and distance to an ending coordinate and
then runs *[r.profile](r.profile.md)*. There once were **width=** and
**result**=*raw\|median\|average* options which are not currently
implemented.

## SEE ALSO

*[r.profile](r.profile.md), [wxGUI profile tool](wxGUI.md)*

## AUTHOR

Michael Shapiro, U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [r.transect source code](https://github.com/OSGeo/grass/tree/main/raster/r.transect)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.transect))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
