---
name: r.topidx
description: Creates a topographic index (wetness index) raster map from an elevation raster map.
keywords: [ raster, hydrology, wetness, topographic index ]
---

# r.topidx

Creates a topographic index (wetness index) raster map from an elevation raster map.

=== "Command line"

    **r.topidx**
    **input**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.topidx input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.topidx***",
        **input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.topidx", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_topidx*(**input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_topidx(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output topographic index raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output topographic index raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output topographic index raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.topidx* creates topographic index (wetness index), ln(a/tan(beta)),
map from elevation map where

- a: the area of the hillslope per unit contour length that drains
  through any point,
- tan(beta): the local surface topographic slope (delta vertical) /
  (delta horizontal).

Input maps may have NULL values. For example, if you have a raster mask
set for a watershed (using basin map from *r.water.outlet*), the
following command will create a masked elevation map (belev):

```sh
r.mapcalc "belev = if(isnull(basin), basin, elev)"
```

*r.stats -Anc* prints out averaged statistics for topographic index.

Lat/long projects are not supported. If data is not projected, please
create a new project with a projected coordinate reference system and
reproject the data there. Please run *r.topidx* from that project.

## EXAMPLE

Running the command below will generate the topographic index map shown
in the figure:

```sh
g.region raster=elevation -p
r.topidx input=elevation output=topidx_elevation
```

![r.topidx example](r_topidx.png)  
*Figure: topographic index map derived from elevation map*

## REFERENCES

Cho, H., 2000. GIS Hydrological Modeling System by Using Programming
Interface of GRASS. Master's Thesis, Department of Civil Engineering,
Kyungpook National University, Korea.

Moore, I.D., R.B. Grayson, and A.R. Ladson, 1991. Digital Terrain
Modeling: A Review of Hydrological, Geomorphological, and Biological
Applications. Hydrological Processes 5:3-30.

## SEE ALSO

*[r.topmodel](r.topmodel.md), [r.water.outlet](r.water.outlet.md),
[r.mapcalc](r.mapcalc.md)*  
[Known issues](http://idea.isnew.info/r.topidx.html)

## AUTHORS

[Huidae Cho](mailto:grass4u@gmail-com)  
Hydro Laboratory, Kyungpook National University, South Korea

Based on GRIDATB.FOR by Keith Beven.

## SOURCE CODE

Available at: [r.topidx source code](https://github.com/OSGeo/grass/tree/main/raster/r.topidx)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.topidx))  
Latest change: Thursday Nov 06 22:27:54 2025 in commit [298b386](https://github.com/OSGeo/grass/commit/298b38614712934179355ea767403d6bfea8f5f9)
