---
name: r.spread
description: Simulates elliptically anisotropic spread. Generates a raster map of the cumulative time of spread, given raster maps containing the rates of spread (ROS), the ROS directions and the spread origins. It optionally produces raster maps to contain backlink UTM coordinates for tracing spread paths. Usable for fire spread simulations.
keywords: [ raster, fire, spread, hazard, model ]
---

# r.spread

Simulates elliptically anisotropic spread.

Generates a raster map of the cumulative time of spread, given raster maps containing the rates of spread (ROS), the ROS directions and the spread origins. It optionally produces raster maps to contain backlink UTM coordinates for tracing spread paths. Usable for fire spread simulations.

=== "Command line"

    **r.spread**
    [**-si**]
    **base_ros**=*string*
    **max_ros**=*string*
    **direction_ros**=*string*
    **start**=*string*
    [**spotting_distance**=*string*]
    [**wind_speed**=*string*]
    [**fuel_moisture**=*string*]
    [**least_size**=*odd int*]
    [**comp_dens**=*decimal*]
    [**init_time**=*int (>= 0)*]
    [**lag**=*int (>= 0)*]
    [**backdrop**=*string*]
    **output**=*string*
    [**x_output**=*string*]
    [**y_output**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.spread base_ros=string max_ros=string direction_ros=string start=string output=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.spread***",
        **base_ros**,
        **max_ros**,
        **direction_ros**,
        **start**,
        **spotting_distance**=*None*,
        **wind_speed**=*None*,
        **fuel_moisture**=*None*,
        **least_size**=*None*,
        **comp_dens**=*None*,
        **init_time**=*"0"*,
        **lag**=*None*,
        **backdrop**=*None*,
        **output**,
        **x_output**=*None*,
        **y_output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.spread", base_ros="string", max_ros="string", direction_ros="string", start="string", output="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_spread*(**base_ros**,
        **max_ros**,
        **direction_ros**,
        **start**,
        **spotting_distance**=*None*,
        **wind_speed**=*None*,
        **fuel_moisture**=*None*,
        **least_size**=*None*,
        **comp_dens**=*None*,
        **init_time**=*"0"*,
        **lag**=*None*,
        **backdrop**=*None*,
        **output**,
        **x_output**=*None*,
        **y_output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_spread(base_ros="string", max_ros="string", direction_ros="string", start="string", output="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **base_ros**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing base ROS (cm/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the ROS values in the directions perpendicular to maximum ROSes' (cm/minute). These ROSes are also the ones without the effect of directional factors.  
    **max_ros**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing maximal ROS (cm/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the maximum ROS values (cm/minute).  
    **direction_ros**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing directions of maximal ROS (degree)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing directions of the maximum ROSes, clockwise from north (degree).  
    **start**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing starting sources  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing starting locations of the spread phenomenon. Any positive integers in this map are recognized as starting sources (seeds).  
    **spotting_distance**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing maximal spotting distance (m, required with -s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the maximum potential spotting distances (meters).  
    **wind_speed**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing midflame wind speed (ft/min, required with -s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing wind velocities at half of the average flame height (feet/minute).  
    **fuel_moisture**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing fine fuel moisture of the cell receiving a spotting firebrand (%, required with -s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the 1-hour (&lt;.25") fuel moisture (percentage content multiplied by 100).  
    **least_size**=*odd int*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basic sampling window size needed to meet certain accuracy (3)  
    &nbsp;&nbsp;&nbsp;&nbsp;An odd integer ranging 3 - 15 indicating the basic sampling window size within which all cells will be considered to see whether they will be reached by the current spread cell. The default number is 3 which means a 3x3 window.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3, 5, 7, 9, 11, 13, 15*  
    **comp_dens**=*decimal*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling density for additional computing (range: 0.0 - 1.0 (0.5))  
    &nbsp;&nbsp;&nbsp;&nbsp;A decimal number ranging 0.0 - 1.0 indicating additional sampling cells will be considered to see whether they will be reached by the current spread cell. The closer to 1.0 the decimal number is, the longer the program will run and the higher the simulation accuracy will be. The default number is 0.5.  
    **init_time**=*int (>= 0)*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial time for current simulation (0) (min)  
    &nbsp;&nbsp;&nbsp;&nbsp;A non-negative number specifying the initial time for the current spread simulation (minutes). This is useful when multiple phase simulation is conducted. The default time is 0.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **lag**=*int (>= 0)*  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulating time duration LAG (fill the region) (min)  
    &nbsp;&nbsp;&nbsp;&nbsp;A non-negative integer specifying the simulating duration time lag (minutes). The default is infinite, but the program will terminate when the current geographic region/mask has been filled. It also controls the computational time, the shorter the time lag, the faster the program will run.  
    **backdrop**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map as a display backdrop  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path to be used as the background on which the "live" movement will be shown.  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to contain output spread time (min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new raster map layer to contain the results of the cumulative spread time needed for a phenomenon to reach each cell from the starting sources (minutes).  
    **x_output**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to contain X back coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new raster map layer to contain the results of backlink information in UTM easting coordinates for each cell.  
    **y_output**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to contain Y back coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new raster map layer to contain the results of backlink information in UTM northing coordinates for each cell.  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Consider spotting effect (for wildfires)  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use start raster map values in output spread time raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Designed to be used with output of previous run of r.spread when computing spread iteratively. The values in start raster map are considered as time. Allowed values in raster map are from zero to the value of init_time option. If not enabled, init_time is used in the area of start raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **base_ros** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing base ROS (cm/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the ROS values in the directions perpendicular to maximum ROSes' (cm/minute). These ROSes are also the ones without the effect of directional factors.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **max_ros** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing maximal ROS (cm/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the maximum ROS values (cm/minute).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **direction_ros** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing directions of maximal ROS (degree)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing directions of the maximum ROSes, clockwise from north (degree).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **start** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing starting sources  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing starting locations of the spread phenomenon. Any positive integers in this map are recognized as starting sources (seeds).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **spotting_distance** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing maximal spotting distance (m, required with -s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the maximum potential spotting distances (meters).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **wind_speed** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing midflame wind speed (ft/min, required with -s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing wind velocities at half of the average flame height (feet/minute).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **fuel_moisture** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing fine fuel moisture of the cell receiving a spotting firebrand (%, required with -s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the 1-hour (&lt;.25") fuel moisture (percentage content multiplied by 100).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **least_size** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basic sampling window size needed to meet certain accuracy (3)  
    &nbsp;&nbsp;&nbsp;&nbsp;An odd integer ranging 3 - 15 indicating the basic sampling window size within which all cells will be considered to see whether they will be reached by the current spread cell. The default number is 3 which means a 3x3 window.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *odd int*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3, 5, 7, 9, 11, 13, 15*  
    **comp_dens** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling density for additional computing (range: 0.0 - 1.0 (0.5))  
    &nbsp;&nbsp;&nbsp;&nbsp;A decimal number ranging 0.0 - 1.0 indicating additional sampling cells will be considered to see whether they will be reached by the current spread cell. The closer to 1.0 the decimal number is, the longer the program will run and the higher the simulation accuracy will be. The default number is 0.5.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *decimal*  
    **init_time** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial time for current simulation (0) (min)  
    &nbsp;&nbsp;&nbsp;&nbsp;A non-negative number specifying the initial time for the current spread simulation (minutes). This is useful when multiple phase simulation is conducted. The default time is 0.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *int (>= 0)*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **lag** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulating time duration LAG (fill the region) (min)  
    &nbsp;&nbsp;&nbsp;&nbsp;A non-negative integer specifying the simulating duration time lag (minutes). The default is infinite, but the program will terminate when the current geographic region/mask has been filled. It also controls the computational time, the shorter the time lag, the faster the program will run.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *int (>= 0)*  
    **backdrop** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map as a display backdrop  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path to be used as the background on which the "live" movement will be shown.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to contain output spread time (min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new raster map layer to contain the results of the cumulative spread time needed for a phenomenon to reach each cell from the starting sources (minutes).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **x_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to contain X back coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new raster map layer to contain the results of backlink information in UTM easting coordinates for each cell.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **y_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to contain Y back coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new raster map layer to contain the results of backlink information in UTM northing coordinates for each cell.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Consider spotting effect (for wildfires)  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use start raster map values in output spread time raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Designed to be used with output of previous run of r.spread when computing spread iteratively. The values in start raster map are considered as time. Allowed values in raster map are from zero to the value of init_time option. If not enabled, init_time is used in the area of start raster map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **base_ros** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing base ROS (cm/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the ROS values in the directions perpendicular to maximum ROSes' (cm/minute). These ROSes are also the ones without the effect of directional factors.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **max_ros** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing maximal ROS (cm/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the maximum ROS values (cm/minute).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **direction_ros** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing directions of maximal ROS (degree)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing directions of the maximum ROSes, clockwise from north (degree).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **start** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing starting sources  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing starting locations of the spread phenomenon. Any positive integers in this map are recognized as starting sources (seeds).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **spotting_distance** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing maximal spotting distance (m, required with -s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the maximum potential spotting distances (meters).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **wind_speed** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing midflame wind speed (ft/min, required with -s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing wind velocities at half of the average flame height (feet/minute).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **fuel_moisture** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing fine fuel moisture of the cell receiving a spotting firebrand (%, required with -s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the 1-hour (&lt;.25") fuel moisture (percentage content multiplied by 100).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **least_size** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basic sampling window size needed to meet certain accuracy (3)  
    &nbsp;&nbsp;&nbsp;&nbsp;An odd integer ranging 3 - 15 indicating the basic sampling window size within which all cells will be considered to see whether they will be reached by the current spread cell. The default number is 3 which means a 3x3 window.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *odd int*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3, 5, 7, 9, 11, 13, 15*  
    **comp_dens** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling density for additional computing (range: 0.0 - 1.0 (0.5))  
    &nbsp;&nbsp;&nbsp;&nbsp;A decimal number ranging 0.0 - 1.0 indicating additional sampling cells will be considered to see whether they will be reached by the current spread cell. The closer to 1.0 the decimal number is, the longer the program will run and the higher the simulation accuracy will be. The default number is 0.5.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *decimal*  
    **init_time** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial time for current simulation (0) (min)  
    &nbsp;&nbsp;&nbsp;&nbsp;A non-negative number specifying the initial time for the current spread simulation (minutes). This is useful when multiple phase simulation is conducted. The default time is 0.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *int (>= 0)*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **lag** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulating time duration LAG (fill the region) (min)  
    &nbsp;&nbsp;&nbsp;&nbsp;A non-negative integer specifying the simulating duration time lag (minutes). The default is infinite, but the program will terminate when the current geographic region/mask has been filled. It also controls the computational time, the shorter the time lag, the faster the program will run.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *int (>= 0)*  
    **backdrop** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map as a display backdrop  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path to be used as the background on which the "live" movement will be shown.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to contain output spread time (min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new raster map layer to contain the results of the cumulative spread time needed for a phenomenon to reach each cell from the starting sources (minutes).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **x_output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to contain X back coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new raster map layer to contain the results of backlink information in UTM easting coordinates for each cell.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **y_output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to contain Y back coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the new raster map layer to contain the results of backlink information in UTM northing coordinates for each cell.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Consider spotting effect (for wildfires)  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use start raster map values in output spread time raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Designed to be used with output of previous run of r.spread when computing spread iteratively. The values in start raster map are considered as time. Allowed values in raster map are from zero to the value of init_time option. If not enabled, init_time is used in the area of start raster map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.spread* is part of the wildfire simulation toolset. Preparational
steps for the fire simulation are the calculation of the rate of spread
(ROS) with *r.ros*, and the creating of spread map with *r.spread*.
Eventually, the fire path(s) based on starting point(s) are calculated
with *r.spreadpath*.

Spread phenomena usually show uneven movement over space. Such
unevenness is due to two reasons:

1. the uneven conditions from location to location, which can be called
    *spatial heterogeneity*, and
2. the uneven conditions in different directions, which can be called
    *anisotropy*.

The anisotropy of spread occurs when any of the determining factors have
directional components. For example, wind and topography cause
anisotropic spread of wildfires.

One of the simplest spatial heterogeneous and anisotropic spread is
elliptical spread, in which, each local spread shape can be thought as
an ellipse. In a raster setting, cell centers are foci of the spread
ellipses, and the spread phenomenon moves fastest toward apogees and
slowest to perigees. The sizes and shapes of spread ellipses may vary
cell by cell. So the overall spread shape is commonly not an ellipse.

*r.spread*simulates elliptically anisotropic spread phenomena, given
three raster map layers about ROS (base ROS, maximum ROS and direction
of the maximum ROS) plus a raster map layer showing the starting
sources. These ROS layers define unique ellipses for all cell locations
in the current computational region as if each cell center was a
potential spread origin. For some wildfire spread, these ROS layers can
be generated by another GRASS raster program r.ros. The actual locations
reached by a spread event are constrained by the actual spread origins
and the elapsed spread time.

*r.spread*optionally produces raster maps to contain backlink UTM
coordinates for each raster cell of the spread time map. The spread
paths can be accurately traced based on the backlink information by
*[r.spreadpath](r.spreadpath.md)* module.

Part of the spotting function in r.spread is based on Chase (1984) and
Rothermel (1983). More information on *r.spread*, *[r.ros](r.ros.md)*
and *[r.spreadpath](r.spreadpath.md)* can be found in Xu (1994).

Options `spot_dist`, `w_speed` and `f_mois` must all be given if the
`-s` (spotting) flag is used.

## EXAMPLE

Assume we have inputs, the following simulates a spotting- involved
wildfire and generates three raster maps to contain spread time,
backlink information in UTM northing and easting coordinates:

```sh
r.spread -s max=my_ros.max dir=my_ros.maxdir base=my_ros.base \
    start=fire_origin spot_dist=my_ros.spotdist w_speed=wind_speed \
    f_mois=1hour_moisture output=my_spread \
    x_output=my_spread.x y_output=my_spread.y
```

## NOTES

1\. *r.spread* is a specific implementation of the shortest path
algorithm. *[r.cost](r.cost.md)* module served as the starting point for
the development of *r.spread*. One of the major differences between the
two programs is that *[r.cost](r.cost.md)* only simulates *isotropic*
spread while *r.spread* can simulate *elliptically anisotropic* spread,
including isotropic spread as a special case.

2\. Before running r.spread, the user should prepare the ROS (base, max
and direction) maps using appropriate models. For some wildfire spread,
the *[r.ros](r.ros.md)* module based on Rothermel's fire equation does
such work. The combination of the two forms a simulation of wildfire
spread.

3\. The relationship of the start map and ROS maps should be logically
correct, i.e. a starting source (a positive value in the start map)
should not be located in a spread *barrier* (zero value in the ROS
maps). Otherwise the program refuses to run.

4\. *r.spread* uses the current computational region settings. The
output map layer will not go outside the boundaries set in the region,
and will not be influenced by starting sources outside. So any change of
the current region may influence the output. The recommendation is to
use slightly larger region than needed. Refer to
*[g.region](g.region.md)* to set an appropriate computational region.

5\. The user should be sure that the inputs to *r.spread* are in proper
units.

6\. *r.spread* is a computationally intensive program. The user may need
to choose appropriate size of the computational region and resolution.

7\. A low and medium (i.e. \<= 0.5) sampling density can improve
accuracy for elliptical simulation significantly, without adding
significantly extra running time. Further increasing the sample density
will not gain much accuracy while requiring greatly additional running
time.

## REFERENCES

- Chase, Carolyn, H., 1984, Spotting distance from wind-driven surface
  fires -- extensions of equations for pocket calculators, US Forest
  Service, Res. Note INT-346, Ogden, Utah.
- Rothermel, R. C., 1983, How to predict the spread and intensity of
  forest and range fires. US Forest Service, Gen. Tech. Rep. INT-143.
  Ogden, Utah.
- Xu, Jianping, 1994, Simulating the spread of wildfires using a
  geographic information system and remote sensing, Ph. D. Dissertation,
  Rutgers University, New Brunswick, New Jersey
  ([ref](https://dl.acm.org/citation.cfm?id=921466)).

## SEE ALSO

*[r.cost](r.cost.md), [r.mask](r.mask.md), [r.ros](r.ros.md),
[r.spreadpath](r.spreadpath.md)* Sample data download:
[firedemo.sh](https://grass.osgeo.org/sampledata/firedemo_grass7.sh)
(run this script within the "Fire simulation data set" project).

## AUTHORS

Jianping Xu and Richard G. Lathrop, Jr., Center for Remote Sensing and
Spatial Analysis, Rutgers University.

## SOURCE CODE

Available at: [r.spread source code](https://github.com/OSGeo/grass/tree/main/raster/r.spread)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.spread))  
Latest change: Tuesday Jun 24 05:57:51 2025 in commit [801e552](https://github.com/OSGeo/grass/commit/801e552cdaf8ef40f8760dbbcc5a4a5b83b14d40)
