---
name: r.buffer.lowmem.py
description: Creates a raster map showing buffer zones surrounding cells that contain non-NULL category values. This is the low-memory alternative to the classic r.buffer module.
keywords: [ raster, buffer ]
---

# r.buffer.lowmem.py

Creates a raster map showing buffer zones surrounding cells that contain non-NULL category values.

This is the low-memory alternative to the classic r.buffer module.

=== "Command line"

    **r.buffer.lowmem.py**
    [**-z**]
    **input**=*name*
    **output**=*name*
    **distances**=*float* [,*float*,...]
    [**units**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.buffer.lowmem.py input=name output=name distances=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.buffer.lowmem.py***",
        **input**,
        **output**,
        **distances**,
        **units**=*"meters"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.buffer.lowmem.py", input="name", output="name", distances=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_buffer_lowmem_py*(**input**,
        **output**,
        **distances**,
        **units**=*"meters"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_buffer_lowmem_py(input="name", output="name", distances=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **distances**=*float* [,*float*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance zone(s)  
    **units**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units of distance  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *meters, kilometers, feet, miles, nautmiles*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *meters*  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore zero (0) data cells instead of NULL cells  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **distances** : float | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance zone(s)  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units of distance  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *meters, kilometers, feet, miles, nautmiles*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *meters*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore zero (0) data cells instead of NULL cells  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **distances** : float | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance zone(s)  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units of distance  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *meters, kilometers, feet, miles, nautmiles*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *meters*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore zero (0) data cells instead of NULL cells  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.buffer.lowmem* creates a new raster map showing buffer (a.k.a.
"distance" or "proximity") zones around all cells that contain non-NULL
category values in an existing raster map. The distances of buffer zones
from cells with non-zero category values are user-chosen.

This is the low-memory alternative to the classic
*[r.buffer](r.buffer.md)* module. It is much slower than the classic
version, but will run on massive raster maps without using a lot of RAM.
If your raster map is larger than 32000x32000 cells on a system with 1
GB of RAM, or larger than 90000x90000 cells on a system with 8 GB of
RAM, consider using this module.

For more info see manual of *[r.buffer](r.buffer.md)*.

## EXAMPLE

In the following example, the buffer zones would be (in the default
units of meters): 0-100, 101-200, 201-300, 301-400 and 401-500.

```sh
r.buffer.lowmem input=roads output=roads.buf distances=100,200,300,400,500
```

Result:

```sh
r.category input=roads.buf

      1       distances calculated from these locations
      2       0-100 meters
      3       100-200 meters
      4       200-300 meters
      5       300-400 meters
      6       400-500 meters
```

## SEE ALSO

*[g.region](g.region.md), [r.buffer](r.buffer.md), [r.cost](r.cost.md),
[r.grow.distance](r.grow.distance.md), [r.mapcalc](r.mapcalc.md),
[r.reclass](r.reclass.md), [v.buffer](v.buffer.md)*

## AUTHORS

Michael Shapiro, U.S. Army Construction Engineering Research
Laboratory  
James Westervelt, U.S. Army Construction Engineering Research
Laboratory  
Low-memory Python version by Glynn Clements

## SOURCE CODE

Available at: [r.buffer.lowmem source code](https://github.com/OSGeo/grass/tree/main/scripts/r.buffer.lowmem)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.buffer.lowmem))  
Latest change: Thursday May 22 03:42:15 2025 in commit [370bcb0](https://github.com/OSGeo/grass/commit/370bcb0490b421ac90b2dbe5766af9512cb08f92)
