---
name: i.albedo
description: Computes broad band albedo from surface reflectance.
keywords: [ imagery, albedo, reflectance, satellite, Landsat, ASTER, AVHRR, MODIS ]
---

# i.albedo

Computes broad band albedo from surface reflectance.

=== "Command line"

    **i.albedo**
    [**-mnl8acd**]
    **input**=*name* [,*name*,...]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.albedo input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.albedo***",
        **input**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.albedo", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_albedo*(**input**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_albedo(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;MODIS (7 input bands:1,2,3,4,5,6,7)  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;NOAA AVHRR (2 input bands:1,2)  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Landsat 5+7 (6 input bands:1,2,3,4,5,7)  
    **-8**  
    &nbsp;&nbsp;&nbsp;&nbsp;Landsat 8 (7 input bands:1,2,3,4,5,6,7)  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;ASTER (6 input bands:1,3,5,6,8,9)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggressive mode (Landsat)  
    &nbsp;&nbsp;&nbsp;&nbsp;Albedo dry run to calculate some water to beach/sand/desert stretching, a kind of simple atmospheric correction  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Soft mode (MODIS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Albedo dry run to calculate some water to beach/sand/desert stretching, a kind of simple atmospheric correction  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *n*, *l*, *8*, *a*, *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;MODIS (7 input bands:1,2,3,4,5,6,7)  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;NOAA AVHRR (2 input bands:1,2)  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Landsat 5+7 (6 input bands:1,2,3,4,5,7)  
    &nbsp;&nbsp;&nbsp;&nbsp;**8**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Landsat 8 (7 input bands:1,2,3,4,5,6,7)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ASTER (6 input bands:1,3,5,6,8,9)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Aggressive mode (Landsat)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Albedo dry run to calculate some water to beach/sand/desert stretching, a kind of simple atmospheric correction  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Soft mode (MODIS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Albedo dry run to calculate some water to beach/sand/desert stretching, a kind of simple atmospheric correction  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *n*, *l*, *8*, *a*, *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;MODIS (7 input bands:1,2,3,4,5,6,7)  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;NOAA AVHRR (2 input bands:1,2)  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Landsat 5+7 (6 input bands:1,2,3,4,5,7)  
    &nbsp;&nbsp;&nbsp;&nbsp;**8**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Landsat 8 (7 input bands:1,2,3,4,5,6,7)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ASTER (6 input bands:1,3,5,6,8,9)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Aggressive mode (Landsat)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Albedo dry run to calculate some water to beach/sand/desert stretching, a kind of simple atmospheric correction  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Soft mode (MODIS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Albedo dry run to calculate some water to beach/sand/desert stretching, a kind of simple atmospheric correction  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.albedo* calculates the albedo, that is the Shortwave surface
reflectance in the range of 0.3-3 micro-meters. It takes as input
individual bands of surface reflectance originating from MODIS, AVHRR,
Landsat or Aster satellite sensors and calculates the albedo for those.
This is a precursor to *r.sun* and any energy-balance processing.

## NOTES

It uses for Landsat 8 the weighted average reflectance (temporary
solution until an algorithm is found).

It assumes MODIS product surface reflectance in \[0;10000\].

## EXAMPLE

The following example creates the raster map "albedo_lsat7_1987" from
the LANDSAT-TM5 bands in the North Carolina dataset:

```sh
g.region raster=lsat5_1987_10 -p
i.albedo -l input=lsat5_1987_10,lsat5_1987_20,lsat5_1987_30,lsat5_1987_40,lsat5_1987_50,lsat5_1987_70 output=albedo_lsat7_1987
```

![i.albedo LANDSAT-TM5 1987 example](i_albedo_landsat5.png)  
*Figure: Resulting albedo map from LANDSAT 5*

The following example creates the raster map "albedo_lsat7_2000" from
the LANDSAT-TM7 bands in the North Carolina dataset:

```sh
g.region raster=lsat7_2000_10 -p
i.albedo -l input=lsat7_2000_10,lsat7_2000_20,lsat7_2000_30,lsat7_2000_40,lsat7_2000_50,lsat7_2000_70 output=albedo_lsat7_2000
```

![i.albedo LANDSAT-TM7 2000 example](i_albedo_landsat7.png)  
*Figure: Resulting albedo map from LANDSAT 7*

## TODO

Maybe change input requirement of MODIS to \[0.0-1.0\]?

## REFERENCES

For a 2 band determination of the Aster BB Albedo see the following:

Salleh and Chan, 2014. Land Surface Albedo Determination: Remote Sensing
and Statistical Validation. in proceedings of FIG 2014
([PDF](https://www.fig.net/resources/proceedings/fig_proceedings/fig2014/papers/ts05g/TS05G_salleh_chan_6910.pdf))

## SEE ALSO

*[r.sun](r.sun.md), [i.vi](i.vi.md)*

## AUTHOR

Yann Chemin

## SOURCE CODE

Available at: [i.albedo source code](https://github.com/OSGeo/grass/tree/main/imagery/i.albedo)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.albedo))  
Latest change: Saturday Oct 11 04:38:40 2025 in commit [3dd71f5](https://github.com/OSGeo/grass/commit/3dd71f5fab83b72a2db2da959fe075c5b3b52200)
