---
name: g.pnmcomp
description: Overlays multiple PPM image files.
keywords: [ general, display ]
---

# g.pnmcomp

Overlays multiple PPM image files.

=== "Command line"

    **g.pnmcomp**
    **input**=*name* [,*name*,...]
    [**mask**=*name* [,*name*,...]]
    [**opacity**=*float* [,*float*,...]]
    **output**=*name*
    [**output_mask**=*name*]
    **width**=*integer*
    **height**=*integer*
    [**bgcolor**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.pnmcomp input=name output=name width=0 height=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.pnmcomp***",
        **input**,
        **mask**=*None*,
        **opacity**=*None*,
        **output**,
        **output_mask**=*None*,
        **width**,
        **height**,
        **bgcolor**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.pnmcomp", input="name", output="name", width=0, height=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_pnmcomp*(**input**,
        **mask**=*None*,
        **opacity**=*None*,
        **output**,
        **output_mask**=*None*,
        **width**,
        **height**,
        **bgcolor**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_pnmcomp(input="name", output="name", width=0, height=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file(s)  
    **mask**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input mask file(s)  
    **opacity**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer opacities  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **output_mask**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output mask file  
    **width**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Image width  
    **height**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Image height  
    **bgcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **mask** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input mask file(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **opacity** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer opacities  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **output_mask** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output mask file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **width** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Image width  
    **height** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Image height  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **mask** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input mask file(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **opacity** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer opacities  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **output_mask** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output mask file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **width** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Image width  
    **height** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Image height  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.pnmcomp* isn't meant for end users. It's an internal tool for use by
*[wxGUI](wxGUI.md)*.

In essence, *g.pnmcomp* generates a PPM image by overlaying a series of
PPM/PGM pairs (PPM = RGB image, PGM = alpha channel).

## NOTES

The intention is that *d.\** modules will emit PPM/PGM pairs (by way of
the PNG-driver code being integrated into Display Library). The GUI will
manage a set of layers; each layer consists of the data necessary to
generate a PPM/PGM pair. Whenever the layer "stack" changes (by adding,
removing, hiding, showing or re-ordering layers), the GUI will render
any layers for which it doesn't already have the PPM/PGM pair, then
re-run *g.pnmcomp* to generate the final image (just redoing the
composition is a lot faster than redrawing everything).

A C/C++ GUI would either have *g.pnmcomp's* functionality (image
composition) built-in, or would use the system's graphics API to perform
composition (for translucent layers, you would need OpenGL or the Render
extension, or something else which supports translucent rendering).

Tk doesn't support transparent (masked) true-colour images (it does
support transparent GIFs, but that's limited to 256 colours), and an
image composition routine in Tcl would be unacceptably slow, hence the
existence of *g.pnmcomp*.

## SEE ALSO

*[g.cairocomp](g.cairocomp.md)*

## AUTHOR

Glynn Clements

## SOURCE CODE

Available at: [g.pnmcomp source code](https://github.com/OSGeo/grass/tree/main/general/g.pnmcomp)
([history](https://github.com/OSGeo/grass/commits/main/general/g.pnmcomp))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
