---
name: g.gui
description: Launches a GRASS graphical user interface (GUI) session. Optionally updates default user interface settings.
keywords: [ general, GUI, user interface ]
---

# g.gui

Launches a GRASS graphical user interface (GUI) session.

Optionally updates default user interface settings.

=== "Command line"

    **g.gui**
    [**-fdn**]
    [**ui**=*string*]
    [**workspace**=*name.gxw*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.gui
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.gui***",
        **ui**=*"wxpython"*,
        **workspace**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.gui")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_gui*(**ui**=*"wxpython"*,
        **workspace**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_gui()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **ui**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;User interface  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wxpython, text, gtext*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *wxpython*  
    &nbsp;&nbsp;&nbsp;&nbsp;**wxpython**: wxPython based GUI (wxGUI)  
    &nbsp;&nbsp;&nbsp;&nbsp;**text**: command line interface only  
    &nbsp;&nbsp;&nbsp;&nbsp;**gtext**: command line interface with GUI startup screen  
    **workspace**=*name.gxw*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of workspace file to load on start-up  
    &nbsp;&nbsp;&nbsp;&nbsp;This is valid only for wxGUI (wxpython)  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Start GUI in the foreground  
    &nbsp;&nbsp;&nbsp;&nbsp;By default the GUI starts in the background and control is immediately returned to the caller. When GUI runs in foregreound, it blocks the command line  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Update default user interface settings  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not launch GUI after updating the default user interface settings  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **ui** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;User interface  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wxpython, text, gtext*  
    &nbsp;&nbsp;&nbsp;&nbsp;**wxpython**: wxPython based GUI (wxGUI)  
    &nbsp;&nbsp;&nbsp;&nbsp;**text**: command line interface only  
    &nbsp;&nbsp;&nbsp;&nbsp;**gtext**: command line interface with GUI startup screen  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *wxpython*  
    **workspace** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of workspace file to load on start-up  
    &nbsp;&nbsp;&nbsp;&nbsp;This is valid only for wxGUI (wxpython)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name.gxw*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *d*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Start GUI in the foreground  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default the GUI starts in the background and control is immediately returned to the caller. When GUI runs in foregreound, it blocks the command line  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update default user interface settings  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not launch GUI after updating the default user interface settings  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **ui** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;User interface  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wxpython, text, gtext*  
    &nbsp;&nbsp;&nbsp;&nbsp;**wxpython**: wxPython based GUI (wxGUI)  
    &nbsp;&nbsp;&nbsp;&nbsp;**text**: command line interface only  
    &nbsp;&nbsp;&nbsp;&nbsp;**gtext**: command line interface with GUI startup screen  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *wxpython*  
    **workspace** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of workspace file to load on start-up  
    &nbsp;&nbsp;&nbsp;&nbsp;This is valid only for wxGUI (wxpython)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name.gxw*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *d*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Start GUI in the foreground  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default the GUI starts in the background and control is immediately returned to the caller. When GUI runs in foregreound, it blocks the command line  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update default user interface settings  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not launch GUI after updating the default user interface settings  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *g.gui* module allows user to start the Graphical User Interface
(GUI) from the command line prompt or to change the default User
Interface (UI) settings.

GRASS comes with both a wxPython-based GUI aka *[wxGUI](wxGUI.md)*
(**ui=wxpython**) and command line text-based UI (**ui=text**).

## NOTES

If the **-d** update flag is given or the `GRASS_GUI` environmental
[variable](variables.md) is unset, then the GRASS internal variable
`GUI` is permanently changed and the selected **ui** will be used as the
default UI from then on.

All GRASS internal variables (see *[g.gisenv](g.gisenv.md)*) are stored
in the user's home directory in a hidden file called `$HOME/.grass8/rc`
on Unix-based operating systems and `%APPDATA%\GRASS8\rc` on MS Windows.
Note that these GRASS internal variables are not the shell environment
variables and the `rc` file is not a classic UNIX run command file, it
just contains persistent GRASS variables.

## EXAMPLES

### Set default user interface settings

Set default user interface setting to command line, text-based UI:

```sh
g.gui -d ui=text
```

Set default user interface setting to the graphical user interface (GUI)
and *launch* the GUI:

```sh
g.gui -d ui=wxpython
```

Set default user interface setting to the graphical user interface (GUI)
but *do not launch* the GUI:

```sh
g.gui -dn ui=wxpython
```

### Load workspace from command line

Start the GUI from command line with an existing workspace:

```sh
g.gui workspace=myproject.gxw
```

## SEE ALSO

*[wxGUI](wxGUI.md), [g.gisenv](g.gisenv.md), [GRASS
variables](variables.md)*

[wxGUI wiki
page](https://grasswiki.osgeo.org/wiki/WxPython-based_GUI_for_GRASS)

## AUTHORS

Martin Landa, FBK-irst, Trento, Italy  
Hamish Bowman, Otago University, Dunedin, New Zealand (fine tuning)

## SOURCE CODE

Available at: [g.gui source code](https://github.com/OSGeo/grass/tree/main/general/g.gui)
([history](https://github.com/OSGeo/grass/commits/main/general/g.gui))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
