<style>
.img-list {
    margin: 0;
    padding: 0;
    list-style-type: none;
}

.img-list li {
    padding: 5px;
    overflow: auto;
}

.img-list li:hover {
    background-color: #eee;
}

.img-list li a {
    color: initial;
    text-decoration: none;
    display: block;
}

.img-list li img {
    width: 10%;
    float: left;
    margin: 0 15px 0 0;
    background: white;
    object-fit: scale-down;
}

.img-list li img.default-img {
    max-height: 5ex;
    background-color: var(--gs-primary-color);
    padding: 5px;
}

.img-list li .desc {
    margin: 0px;
}

.img-list li .name {
    margin: 5px;
    display: block;
    color: #409940;
    font-weight: bold;
    font-style: italic;
}
</style>
Go to <a href="displayintro.html">display introduction</a> | <a href="topics.html">topics</a> <p>
# Display tools
<ul class="img-list"><li><a href="d.background.html"><img class="linkimg" src="d_background.png"></a><a href="d.background.html"><span class="name">d.background</span> <span class="desc">Fills the graphics display frame with user defined color.</span></a></li><li><a href="d.barscale.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.barscale.html"><span class="name">d.barscale</span> <span class="desc">Displays a barscale on the graphics monitor.</span></a></li><li><a href="d.colorlist.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.colorlist.html"><span class="name">d.colorlist</span> <span class="desc">Outputs a list of all available display colors.</span></a></li><li><a href="d.colortable.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.colortable.html"><span class="name">d.colortable</span> <span class="desc">Displays the color table associated with a raster map layer.</span></a></li><li><a href="d.correlate.html"><img class="linkimg" src="d_correlate_plot.png"></a><a href="d.correlate.html"><span class="name">d.correlate</span> <span class="desc">Prints a graph of the correlation between raster maps (in pairs).</span></a></li><li><a href="d.erase.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.erase.html"><span class="name">d.erase</span> <span class="desc">Erases the contents of the active graphics display frame with user defined color.</span></a></li><li><a href="d.font.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.font.html"><span class="name">d.font</span> <span class="desc">Selects the font in which text will be displayed on the user's graphics monitor.</span></a></li><li><a href="d.fontlist.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.fontlist.html"><span class="name">d.fontlist</span> <span class="desc">Lists the available fonts.</span></a></li><li><a href="d.frame.html"><img class="linkimg" src="d_frame.png"></a><a href="d.frame.html"><span class="name">d.frame</span> <span class="desc">Manages display frames on the user's graphics monitor.</span></a></li><li><a href="d.geodesic.html"><img class="linkimg" src="d_geodesic.png"></a><a href="d.geodesic.html"><span class="name">d.geodesic</span> <span class="desc">Displays a geodesic line, tracing the shortest distance between two geographic points along a great circle, in a longitude/latitude data set.</span></a></li><li><a href="d.graph.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.graph.html"><span class="name">d.graph</span> <span class="desc">Program for generating and displaying simple graphics on the display monitor.</span></a></li><li><a href="d.grid.html"><img class="linkimg" src="d_grid_red_grid.png"></a><a href="d.grid.html"><span class="name">d.grid</span> <span class="desc">Overlays a user-specified grid in the active display frame on the graphics monitor.</span></a></li><li><a href="d.his.html"><img class="linkimg" src="d_histogram_bar.png"></a><a href="d.his.html"><span class="name">d.his</span> <span class="desc">Displays the result obtained by combining hue, intensity, and saturation (HIS) values from user-specified input raster map layers.</span></a></li><li><a href="d.histogram.html"><img class="linkimg" src="d_histogram_bar.png"></a><a href="d.histogram.html"><span class="name">d.histogram</span> <span class="desc">Displays a histogram in the form of a pie or bar chart for a user-specified raster map.</span></a></li><li><a href="d.info.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.info.html"><span class="name">d.info</span> <span class="desc">Displays information about the active display monitor. Display monitors are maintained by d.mon.</span></a></li><li><a href="d.labels.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.labels.html"><span class="name">d.labels</span> <span class="desc">Displays text labels (created with v.label) to the active frame on the graphics monitor.</span></a></li><li><a href="d.legend.html"><img class="linkimg" src="d_legend.png"></a><a href="d.legend.html"><span class="name">d.legend</span> <span class="desc">Displays a legend for a 2D or 3D raster map in the active frame of the graphics monitor.</span></a></li><li><a href="d.legend.vect.html"><img class="linkimg" src="d_legend_vect.png"></a><a href="d.legend.vect.html"><span class="name">d.legend.vect</span> <span class="desc">Displays a vector legend in the active graphics frame.</span></a></li><li><a href="d.linegraph.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.linegraph.html"><span class="name">d.linegraph</span> <span class="desc">Generates and displays simple line graphs in the active graphics monitor display frame.</span></a></li><li><a href="d.mon.html"><img class="linkimg" src="d_mon_wx0.png"></a><a href="d.mon.html"><span class="name">d.mon</span> <span class="desc">Controls graphics display monitors from the command line.</span></a></li><li><a href="d.northarrow.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.northarrow.html"><span class="name">d.northarrow</span> <span class="desc">Displays a north arrow on the graphics monitor.</span></a></li><li><a href="d.out.file.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.out.file.html"><span class="name">d.out.file</span> <span class="desc">Saves the contents of the active display monitor to a graphics file.</span></a></li><li><a href="d.path.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.path.html"><span class="name">d.path</span> <span class="desc">Finds shortest path for selected starting and ending node.</span></a></li><li><a href="d.polar.html"><img class="linkimg" src="d_polar_aspect.png"></a><a href="d.polar.html"><span class="name">d.polar</span> <span class="desc">Draws polar diagram of angle map such as aspect or flow directions</span></a></li><li><a href="d.profile.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.profile.html"><span class="name">d.profile</span> <span class="desc">Plots profile of a transect.</span></a></li><li><a href="d.rast.arrow.html"><img class="linkimg" src="d_rast_arrow_wind.png"></a><a href="d.rast.arrow.html"><span class="name">d.rast.arrow</span> <span class="desc">Draws arrows representing cell aspect direction for a raster map containing aspect data.</span></a></li><li><a href="d.rast.edit.html"><img class="linkimg" src="d_rast_edit.png"></a><a href="d.rast.edit.html"><span class="name">d.rast.edit</span> <span class="desc">Edits cell values in a raster map.</span></a></li><li><a href="d.rast.leg.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.rast.leg.html"><span class="name">d.rast.leg</span> <span class="desc">Displays a raster map and its legend on a graphics window</span></a></li><li><a href="d.rast.html"><img class="linkimg" src="d_rast_edit.png"></a><a href="d.rast.html"><span class="name">d.rast</span> <span class="desc">Displays user-specified raster map in the active graphics frame.</span></a></li><li><a href="d.rast.num.html"><img class="linkimg" src="d_rast_num_zoom.png"></a><a href="d.rast.num.html"><span class="name">d.rast.num</span> <span class="desc">Overlays cell category values on a raster map displayed in the active graphics frame.</span></a></li><li><a href="d.redraw.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.redraw.html"><span class="name">d.redraw</span> <span class="desc">Redraws the content of currently selected monitor.</span></a></li><li><a href="d.rgb.html"><img class="linkimg" src="d_rgb.png"></a><a href="d.rgb.html"><span class="name">d.rgb</span> <span class="desc">Displays three user-specified raster maps as red, green, and blue overlays in the active graphics frame.</span></a></li><li><a href="d.rhumbline.html"><img class="linkimg" src="d_rhumbline.png"></a><a href="d.rhumbline.html"><span class="name">d.rhumbline</span> <span class="desc">Displays the rhumbline joining two longitude/latitude coordinates.</span></a></li><li><a href="d.shade.html"><img class="linkimg" src="dshade.png"></a><a href="d.shade.html"><span class="name">d.shade</span> <span class="desc">Drapes a color raster over an shaded relief or aspect map.</span></a></li><li><a href="d.text.html"><img class="linkimg" src="d_text.png"></a><a href="d.text.html"><span class="name">d.text</span> <span class="desc">Draws text in the active display frame on the graphics monitor using the current font.</span></a></li><li><a href="d.title.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.title.html"><span class="name">d.title</span> <span class="desc">Create a TITLE for a raster map in a form suitable for display with d.text.</span></a></li><li><a href="d.to.rast.html"><img class="linkimg" src="d_to_rast_3D_example.jpg"></a><a href="d.to.rast.html"><span class="name">d.to.rast</span> <span class="desc">Saves the contents of the active display monitor to a raster map.</span></a></li><li><a href="d.vect.chart.html"><img class="linkimg" src="d_vect_chart_legend.png"></a><a href="d.vect.chart.html"><span class="name">d.vect.chart</span> <span class="desc">Displays charts of vector data in the active frame on the graphics monitor.</span></a></li><li><a href="d.vect.html"><img class="linkimg" src="d_vect_thematic.png"></a><a href="d.vect.html"><span class="name">d.vect</span> <span class="desc">Displays user-specified vector map in the active graphics frame.</span></a></li><li><a href="d.vect.thematic.html"><img class="linkimg" src="d_vect_thematic.png"></a><a href="d.vect.thematic.html"><span class="name">d.vect.thematic</span> <span class="desc">Displays a thematic vector map in the active graphics frame.</span></a></li><li><a href="d.what.rast.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.what.rast.html"><span class="name">d.what.rast</span> <span class="desc">Allows the user to interactively query raster map layers at user-selected locations.</span></a></li><li><a href="d.what.vect.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.what.vect.html"><span class="name">d.what.vect</span> <span class="desc">Allows the user to interactively query vector map layers at user-selected locations.</span></a></li><li><a href="d.where.html"><img class="default-img" src="grass_logo.svg"></a><a href="d.where.html"><span class="name">d.where</span> <span class="desc">Identifies the geographic coordinates associated with point locations given in display coordinates.</span></a></li></ul>