---
name: d.northarrow
description: Displays a north arrow on the graphics monitor.
keywords: [ display, cartography, map annotations, arrow ]
---

# d.northarrow

Displays a north arrow on the graphics monitor.

=== "Command line"

    **d.northarrow**
    [**-twr**]
    [**style**=*string*]
    [**at**=*x,y*]
    [**rotation**=*float*]
    [**label**=*string*]
    [**color**=*name*]
    [**fill_color**=*name*]
    [**text_color**=*name*]
    [**width**=*float*]
    [**font**=*string*]
    [**fontsize**=*float*]
    [**path**=*name*]
    [**charset**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.northarrow
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.northarrow***",
        **style**=*"1a"*,
        **at**=*"85.0,15.0"*,
        **rotation**=*0*,
        **label**=*"N"*,
        **color**=*"black"*,
        **fill_color**=*"black"*,
        **text_color**=*None*,
        **width**=*0*,
        **font**=*None*,
        **fontsize**=*14*,
        **path**=*None*,
        **charset**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.northarrow")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_northarrow*(**style**=*"1a"*,
        **at**=*"85.0,15.0"*,
        **rotation**=*0*,
        **label**=*"N"*,
        **color**=*"black"*,
        **fill_color**=*"black"*,
        **text_color**=*None*,
        **width**=*0*,
        **font**=*None*,
        **fontsize**=*14*,
        **path**=*None*,
        **charset**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_northarrow()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **style**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;North arrow style  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1a, 1b, 2, 3, 4, 5, 6, 7a, 7b, 8a, 8b, 9, fancy_compass, basic_compass, arrow1, arrow2, arrow3, star*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1a*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![1a](northarrows/1a.png) &nbsp;&nbsp;&nbsp;&nbsp;**1a**: Two color arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![1b](northarrows/1b.png) &nbsp;&nbsp;&nbsp;&nbsp;**1b**: Two color arrowhead with circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![2](northarrows/2.png) &nbsp;&nbsp;&nbsp;&nbsp;**2**: Narrow with blending N  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![3](northarrows/3.png) &nbsp;&nbsp;&nbsp;&nbsp;**3**: Long with small arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![4](northarrows/4.png) &nbsp;&nbsp;&nbsp;&nbsp;**4**: Inverted narrow inside a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![5](northarrows/5.png) &nbsp;&nbsp;&nbsp;&nbsp;**5**: Triangle and N inside a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![6](northarrows/6.png) &nbsp;&nbsp;&nbsp;&nbsp;**6**: Arrowhead and N inside a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![7a](northarrows/7a.png) &nbsp;&nbsp;&nbsp;&nbsp;**7a**: Tall half convex arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![7b](northarrows/7b.png) &nbsp;&nbsp;&nbsp;&nbsp;**7b**: Tall half concave arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![8a](northarrows/8a.png) &nbsp;&nbsp;&nbsp;&nbsp;**8a**: Thin arrow in a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![8b](northarrows/8b.png) &nbsp;&nbsp;&nbsp;&nbsp;**8b**: Fat arrow in a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![9](northarrows/9.png) &nbsp;&nbsp;&nbsp;&nbsp;**9**: One color arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fancy_compass](northarrows/fancy_compass.png) &nbsp;&nbsp;&nbsp;&nbsp;**fancy_compass**: Fancy compass  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![basic_compass](northarrows/basic_compass.png) &nbsp;&nbsp;&nbsp;&nbsp;**basic_compass**: Basic compass  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![arrow1](northarrows/arrow1.png) &nbsp;&nbsp;&nbsp;&nbsp;**arrow1**: Simple arrow  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![arrow2](northarrows/arrow2.png) &nbsp;&nbsp;&nbsp;&nbsp;**arrow2**: Thin arrow  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![arrow3](northarrows/arrow3.png) &nbsp;&nbsp;&nbsp;&nbsp;**arrow3**: Fat arrow  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![star](northarrows/star.png) &nbsp;&nbsp;&nbsp;&nbsp;**star**: 4-point star  
    **at**=*x,y*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen coordinates of the rectangle's top-left corner  
    &nbsp;&nbsp;&nbsp;&nbsp;(0,0) is lower-left of the display frame  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *85.0,15.0*  
    **rotation**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotation angle in degrees (counter-clockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **label**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Displayed letter on the top of arrow  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *N*  
    **color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **fill_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fill color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **text_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    **width**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **fontsize**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *14*  
    **path**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to font file  
    **charset**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding (only applicable to TrueType fonts)  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw the symbol without text  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not rotate text with symbol  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use radians instead of degrees for rotation  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **style** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;North arrow style  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, northarrow  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1a, 1b, 2, 3, 4, 5, 6, 7a, 7b, 8a, 8b, 9, fancy_compass, basic_compass, arrow1, arrow2, arrow3, star*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![1a](northarrows/1a.png) &nbsp;&nbsp;&nbsp;&nbsp;**1a**: Two color arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![1b](northarrows/1b.png) &nbsp;&nbsp;&nbsp;&nbsp;**1b**: Two color arrowhead with circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![2](northarrows/2.png) &nbsp;&nbsp;&nbsp;&nbsp;**2**: Narrow with blending N  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![3](northarrows/3.png) &nbsp;&nbsp;&nbsp;&nbsp;**3**: Long with small arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![4](northarrows/4.png) &nbsp;&nbsp;&nbsp;&nbsp;**4**: Inverted narrow inside a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![5](northarrows/5.png) &nbsp;&nbsp;&nbsp;&nbsp;**5**: Triangle and N inside a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![6](northarrows/6.png) &nbsp;&nbsp;&nbsp;&nbsp;**6**: Arrowhead and N inside a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![7a](northarrows/7a.png) &nbsp;&nbsp;&nbsp;&nbsp;**7a**: Tall half convex arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![7b](northarrows/7b.png) &nbsp;&nbsp;&nbsp;&nbsp;**7b**: Tall half concave arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![8a](northarrows/8a.png) &nbsp;&nbsp;&nbsp;&nbsp;**8a**: Thin arrow in a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![8b](northarrows/8b.png) &nbsp;&nbsp;&nbsp;&nbsp;**8b**: Fat arrow in a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![9](northarrows/9.png) &nbsp;&nbsp;&nbsp;&nbsp;**9**: One color arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fancy_compass](northarrows/fancy_compass.png) &nbsp;&nbsp;&nbsp;&nbsp;**fancy_compass**: Fancy compass  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![basic_compass](northarrows/basic_compass.png) &nbsp;&nbsp;&nbsp;&nbsp;**basic_compass**: Basic compass  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![arrow1](northarrows/arrow1.png) &nbsp;&nbsp;&nbsp;&nbsp;**arrow1**: Simple arrow  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![arrow2](northarrows/arrow2.png) &nbsp;&nbsp;&nbsp;&nbsp;**arrow2**: Thin arrow  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![arrow3](northarrows/arrow3.png) &nbsp;&nbsp;&nbsp;&nbsp;**arrow3**: Fat arrow  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![star](northarrows/star.png) &nbsp;&nbsp;&nbsp;&nbsp;**star**: 4-point star  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1a*  
    **at** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen coordinates of the rectangle's top-left corner  
    &nbsp;&nbsp;&nbsp;&nbsp;(0,0) is lower-left of the display frame  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *85.0,15.0*  
    **rotation** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotation angle in degrees (counter-clockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **label** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Displayed letter on the top of arrow  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *N*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **fill_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fill color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **text_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    **width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **fontsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *14*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to font file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **charset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding (only applicable to TrueType fonts)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *w*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw the symbol without text  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not rotate text with symbol  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use radians instead of degrees for rotation  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **style** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;North arrow style  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, northarrow  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1a, 1b, 2, 3, 4, 5, 6, 7a, 7b, 8a, 8b, 9, fancy_compass, basic_compass, arrow1, arrow2, arrow3, star*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![1a](northarrows/1a.png) &nbsp;&nbsp;&nbsp;&nbsp;**1a**: Two color arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![1b](northarrows/1b.png) &nbsp;&nbsp;&nbsp;&nbsp;**1b**: Two color arrowhead with circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![2](northarrows/2.png) &nbsp;&nbsp;&nbsp;&nbsp;**2**: Narrow with blending N  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![3](northarrows/3.png) &nbsp;&nbsp;&nbsp;&nbsp;**3**: Long with small arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![4](northarrows/4.png) &nbsp;&nbsp;&nbsp;&nbsp;**4**: Inverted narrow inside a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![5](northarrows/5.png) &nbsp;&nbsp;&nbsp;&nbsp;**5**: Triangle and N inside a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![6](northarrows/6.png) &nbsp;&nbsp;&nbsp;&nbsp;**6**: Arrowhead and N inside a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![7a](northarrows/7a.png) &nbsp;&nbsp;&nbsp;&nbsp;**7a**: Tall half convex arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![7b](northarrows/7b.png) &nbsp;&nbsp;&nbsp;&nbsp;**7b**: Tall half concave arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![8a](northarrows/8a.png) &nbsp;&nbsp;&nbsp;&nbsp;**8a**: Thin arrow in a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![8b](northarrows/8b.png) &nbsp;&nbsp;&nbsp;&nbsp;**8b**: Fat arrow in a circle  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![9](northarrows/9.png) &nbsp;&nbsp;&nbsp;&nbsp;**9**: One color arrowhead  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fancy_compass](northarrows/fancy_compass.png) &nbsp;&nbsp;&nbsp;&nbsp;**fancy_compass**: Fancy compass  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![basic_compass](northarrows/basic_compass.png) &nbsp;&nbsp;&nbsp;&nbsp;**basic_compass**: Basic compass  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![arrow1](northarrows/arrow1.png) &nbsp;&nbsp;&nbsp;&nbsp;**arrow1**: Simple arrow  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![arrow2](northarrows/arrow2.png) &nbsp;&nbsp;&nbsp;&nbsp;**arrow2**: Thin arrow  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![arrow3](northarrows/arrow3.png) &nbsp;&nbsp;&nbsp;&nbsp;**arrow3**: Fat arrow  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![star](northarrows/star.png) &nbsp;&nbsp;&nbsp;&nbsp;**star**: 4-point star  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1a*  
    **at** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen coordinates of the rectangle's top-left corner  
    &nbsp;&nbsp;&nbsp;&nbsp;(0,0) is lower-left of the display frame  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *85.0,15.0*  
    **rotation** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotation angle in degrees (counter-clockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **label** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Displayed letter on the top of arrow  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *N*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **fill_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fill color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **text_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    **width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **fontsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *14*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to font file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **charset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding (only applicable to TrueType fonts)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *w*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw the symbol without text  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not rotate text with symbol  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use radians instead of degrees for rotation  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.northarrow* displays a north arrow symbol at the given screen
coordinates. If no coordinates are given it will draw the north arrow in
the bottom right of the display. It can draw the north arrow in a number
of styles (see the [wiki
page](https://grasswiki.osgeo.org/wiki/Cartography#Display_monitors) for
details). With certain styles of north arrow label 'N' is displayed by
default, and can be changed with option **label**, for example for
different languages. The label can be hidden with **-t** flag.

North arrow can be rotated, for example to align with true north, not
grid north. The angle in degrees counter-clockwise (or radians with
**-r** flag) can be specified with option **rotation**. Label is rotated
together with the arrow, unless flag **-w** is specified.

## EXAMPLES

Display a north arrow symbol as a basic compas with label NORTH, rotated
by 8 degrees with label, with black line and gray fill:  

```sh
d.mon wx0
d.northarrow style=basic_compas rotation=8 label=NORTH -w color=black fill_color=gray
d.mon -r
```

## SEE ALSO

*[d.barscale](d.barscale.md), [d.graph](d.graph.md),
[d.grid](d.grid.md), [d.legend](d.legend.md)*

## AUTHORS

Hamish Bowman, *Department of Geology, University of Otago, New
Zealand*  
Improvements as part of GSoC 2016 by Adam Laza, *CTU in Prague*

## SOURCE CODE

Available at: [d.northarrow source code](https://github.com/OSGeo/grass/tree/main/display/d.northarrow)
([history](https://github.com/OSGeo/grass/commits/main/display/d.northarrow))  
Latest change: Tuesday Feb 11 14:24:00 2025 in commit [bd67b98](https://github.com/OSGeo/grass/commit/bd67b98c0880c588e271f114b749ae14fa3e0466)
