# GRASS - wxPython Graphical User Interface (wxGUI)

## 1 - REQUIREMENTS

See `[../../REQUIREMENTS.md](../../REQUIREMENTS.md)`

## 2 - STARTUP WITH GRASS INITIALIZATION

If you want to launch wxPython GUI automatically, start GRASS with
`--gui` parameter

`$ grass --gui`

## 3 - STARTUP FROM GRASS TERMINAL

Simply run

`$ g.gui wxpython`

from the GRASS terminal.

You can also specify workspace file to load on startup.

`$ g.gui gui=wxpython workspace=myworkspace.gxw`

## 4 - DEBUGGING

To enable GUI debug messages on given level set `WX_DEBUG` environment
variable, e.g.

`$ g.gisenv set="WX_DEBUG=3"`

## 5 - CLI BASED DISPLAY USAGE

Use command `d.mon` (shell script in `gui/scripts/` directory) to start map
display:

`GRASS> d.mon wx[0-6]`

After a while, new window should appear. If this is your case, you can now
add some layers, e.g. a raster layer to the map display:

`GRASS> d.rast aspect`

And try the vector layer, too

`GRASS> d.vect roads`

You should be able to zoom & pan through the map, once the layers are
displayed. You should be also able to store the display content as well as
clear the display and start from scratch.

## 6 TRANSLATION HANDLING

Notes:

- Help part of menu entries is coming from the module descriptions
- The menu is generated by `./tools/build_modules_xml.py`

Update of module description strings in `./xml/menudata.xml`:

- in a GRASS session, run `./tools/update_menudata.py`

From this (updated) `./xml/menudata.xml`, the gettext strings are generated
via Makefile and stored into the file `menustrings.py`.

While generating the po files in `../../locale/po/` by `../../locale/Makefile`,
all `.py` files are parsed and the strings are stored in
`../../locale/po/grasswxpy_XX.po`.
