"""Python interface to launch GRASS modules in scripts"""

from . import setup
from .core import (
    PIPE,
    Popen,
    call,
    compare_key_value_text_files,
    create_environment,
    create_location,
    create_project,
    debug,
    debug_level,
    del_temp_region,
    error,
    exec_command,
    fatal,
    feed_command,
    find_file,
    find_program,
    get_capture_stderr,
    get_commands,
    get_raise_on_error,
    get_real_command,
    gisenv,
    handle_errors,
    info,
    legal_name,
    list_grouped,
    list_pairs,
    list_strings,
    locn_is_latlong,
    make_command,
    mapsets,
    message,
    named_colors,
    overwrite,
    parse_color,
    parse_command,
    parser,
    percent,
    pipe_command,
    popen_args_command,
    read_command,
    region,
    region_env,
    run_command,
    sanitize_mapset_environment,
    set_capture_stderr,
    set_raise_on_error,
    start_command,
    tempdir,
    tempfile,
    tempname,
    use_temp_region,
    verbose,
    verbosity,
    version,
    warning,
    write_command,
)
from .db import (
    db_begin_transaction,
    db_commit_transaction,
    db_connection,
    db_describe,
    db_select,
    db_table_exist,
    db_table_in_vector,
)
from .imagery import group_to_dict
from .raster import (
    mapcalc,
    mapcalc_start,
    raster_history,
    raster_info,
    raster_what,
    MaskManager,
    RegionManager,
    RegionManagerEnv,
)
from .raster3d import mapcalc3d, raster3d_info
from .utils import (
    KeyValue,
    append_node_pid,
    append_random,
    append_uuid,
    basename,
    clock,
    decode,
    diff_files,
    encode,
    float_or_dms,
    get_lib_path,
    get_num_suffix,
    legalize_vector_name,
    natural_sort,
    naturally_sorted,
    parse_key_val,
    separator,
    set_path,
    split,
    text_to_string,
    try_remove,
    try_rmdir,
)
from .vector import (
    vector_columns,
    vector_db,
    vector_db_select,
    vector_history,
    vector_info,
    vector_info_topo,
    vector_layer_db,
    vector_what,
)

__all__ = [
    "PIPE",
    "KeyValue",
    "MaskManager",
    "Popen",
    "RegionManager",
    "RegionManagerEnv",
    "append_node_pid",
    "append_random",
    "append_uuid",
    "basename",
    "call",
    "clock",
    "compare_key_value_text_files",
    "create_environment",
    "create_location",
    "create_project",
    "db_begin_transaction",
    "db_commit_transaction",
    "db_connection",
    "db_describe",
    "db_select",
    "db_table_exist",
    "db_table_in_vector",
    "debug",
    "debug_level",
    "decode",
    "del_temp_region",
    "diff_files",
    "encode",
    "error",
    "exec_command",
    "fatal",
    "feed_command",
    "find_file",
    "find_program",
    "float_or_dms",
    "get_capture_stderr",
    "get_commands",
    "get_lib_path",
    "get_num_suffix",
    "get_raise_on_error",
    "get_real_command",
    "gisenv",
    "group_to_dict",
    "handle_errors",
    "info",
    "legal_name",
    "legalize_vector_name",
    "list_grouped",
    "list_pairs",
    "list_strings",
    "locn_is_latlong",
    "make_command",
    "mapcalc",
    "mapcalc3d",
    "mapcalc_start",
    "mapsets",
    "message",
    "named_colors",
    "natural_sort",
    "naturally_sorted",
    "overwrite",
    "parse_color",
    "parse_command",
    "parse_key_val",
    "parser",
    "percent",
    "pipe_command",
    "popen_args_command",
    "raster3d_info",
    "raster_history",
    "raster_info",
    "raster_what",
    "read_command",
    "region",
    "region_env",
    "run_command",
    "sanitize_mapset_environment",
    "separator",
    "set_capture_stderr",
    "set_path",
    "set_raise_on_error",
    "setup",
    "split",
    "start_command",
    "tempdir",
    "tempfile",
    "tempname",
    "text_to_string",
    "try_remove",
    "try_rmdir",
    "use_temp_region",
    "vector_columns",
    "vector_db",
    "vector_db_select",
    "vector_history",
    "vector_info",
    "vector_info_topo",
    "vector_layer_db",
    "vector_what",
    "verbose",
    "verbosity",
    "version",
    "warning",
    "write_command",
]
