---
name: v.out.svg
description: Exports a vector map to SVG file.
keywords: [ vector, export, output ]
---

# v.out.svg

Exports a vector map to SVG file.

=== "Command line"

    **v.out.svg**
    **input**=*name*
    [**layer**=*string*]
    **output**=*name*
    **type**=*string*
    [**precision**=*integer*]
    [**attribute**=*name* [,*name*,...]]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.out.svg input=name output=name type=poly
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.out.svg***",
        **input**,
        **layer**=*"-1"*,
        **output**,
        **type**=*"poly"*,
        **precision**=*6*,
        **attribute**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.out.svg", input="name", output="name", type="poly")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_out_svg*(**input**,
        **layer**=*"-1"*,
        **output**,
        **type**=*"poly"*,
        **precision**=*6*,
        **attribute**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_out_svg(input="name", output="name", type="poly")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for SVG output file  
    **type**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output type  
    &nbsp;&nbsp;&nbsp;&nbsp;Defines which feature-type will be extracted  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *poly, line, point*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *poly*  
    **precision**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinate precision  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **attribute**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute(s) to include in output SVG  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for SVG output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **type** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output type  
    &nbsp;&nbsp;&nbsp;&nbsp;Defines which feature-type will be extracted  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *poly, line, point*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *poly*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinate precision  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **attribute** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute(s) to include in output SVG  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for SVG output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **type** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output type  
    &nbsp;&nbsp;&nbsp;&nbsp;Defines which feature-type will be extracted  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *poly, line, point*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *poly*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinate precision  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **attribute** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute(s) to include in output SVG  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.out.svg* converts GRASS vector data to SVG (Scalable Vector Graphics)
code notation. In particular, it

- converts GRASS line, boundary, area, point, centroid objects to SVG
  \<path /\>, \<circle /\> elements,
- reduces coordinate precision in SVG-output to save bandwidth,
- extracts GRASS attributes to gg:name="value" attributes.

The *precision* parameter controls the number of decimals for
coordinates output (*precision=0* corresponds to integer precision in
the output SVG file).

## EXAMPLE

Export **polygons** from GRASS vector map soils (Spearfish sample data)
to SVG format:

```sh
v.out.svg input=soils output=/tmp/output.svg type=poly
```

Export **lines** from GRASS vector map t_hydro (Spearfish sample data)
to SVG format, set coordinate precision to 0:

```sh
v.out.svg input=t_hydro output=/tmp/output.svg type=line precision=0
```

Export **points** from GRASS vector map archsites (Spearfish sample
data) to SVG format, include attribute **str1** (name):

```sh
v.out.svg input=archsites output=/tmp/output.svg type=point precision=0 attrib=str1
```

## REFERENCES

- [Module v.out.svg at svg.cc](http://svg.cc/grass/index.html)
- [SVG (Scalable Vector Graphics) at
  w3c.org](http://www.w3.org/Graphics/SVG/)

## SEE ALSO

*[v.out.ogr](v.out.ogr.md)*

## AUTHOR

Klaus Foerster (klaus svg.cc), Innsbruck, Austria

## SOURCE CODE

Available at: [v.out.svg source code](https://github.com/OSGeo/grass/tree/main/vector/v.out.svg)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.out.svg))  
Latest change: Friday Sep 05 13:39:09 2025 in commit [f2d027a](https://github.com/OSGeo/grass/commit/f2d027ab71b4f30ff9b8f9e997af30f262070a32)
