---
name: v.db.addtable.py
description: Creates and connects a new attribute table to a given layer of an existing vector map.
keywords: [ vector, attribute table, database ]
---

# v.db.addtable.py

Creates and connects a new attribute table to a given layer of an existing vector map.

=== "Command line"

    **v.db.addtable.py**
    **map**=*name*
    [**table**=*string*]
    [**layer**=*integer*]
    [**key**=*name*]
    [**columns**=*name type* [,*name type*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.db.addtable.py map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.db.addtable.py***",
        **map**,
        **table**=*None*,
        **layer**=*1*,
        **key**=*"cat"*,
        **columns**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.db.addtable.py", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_db_addtable_py*(**map**,
        **table**=*None*,
        **layer**=*1*,
        **key**=*"cat"*,
        **columns**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_db_addtable_py(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **table**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of new attribute table (default: vector map name)  
    **layer**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where to add new attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **key**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of key column  
    &nbsp;&nbsp;&nbsp;&nbsp;Must refer to an integer column  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cat*  
    **columns**=*name type* [,*name type*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name and type of the new column(s) ('name type [,name type, ...]')  
    &nbsp;&nbsp;&nbsp;&nbsp;Types depend on database backend, but all support VARCHAR(), INT, DOUBLE PRECISION and DATE. Example: 'label varchar(250), value integer'  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of new attribute table (default: vector map name)  
    **layer** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where to add new attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **key** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of key column  
    &nbsp;&nbsp;&nbsp;&nbsp;Must refer to an integer column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cat*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name and type of the new column(s) ('name type [,name type, ...]')  
    &nbsp;&nbsp;&nbsp;&nbsp;Types depend on database backend, but all support VARCHAR(), INT, DOUBLE PRECISION and DATE. Example: 'label varchar(250), value integer'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name type*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of new attribute table (default: vector map name)  
    **layer** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where to add new attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **key** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of key column  
    &nbsp;&nbsp;&nbsp;&nbsp;Must refer to an integer column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cat*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name and type of the new column(s) ('name type [,name type, ...]')  
    &nbsp;&nbsp;&nbsp;&nbsp;Types depend on database backend, but all support VARCHAR(), INT, DOUBLE PRECISION and DATE. Example: 'label varchar(250), value integer'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name type*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.db.addtable* creates and adds a new attribute table to a given vector
map. It links the table to the specified layer of the vector map. If the
vector map is not yet linked to any table, new a database link is
established based on the MAPSET database settings (see *db.connect*).

## NOTES

*v.db.addtable* is a front-end to *db.execute* to allow easier usage.

*v.db.addtable* will only insert category values into the table for
those features which actually have a category value in the relevant
layer. The user can add category values automatically by using
*v.category* or manually with *[wxGUI vector
digitizer](wxGUI.vdigit.md)* before running v.db.addtable. Or one can
run v.db.addtable first and then use either a combinatino of
*v.category* + *v.to.db* or *[wxGUI vector digitizer](wxGUI.vdigit.md)*
to add the relevant lines to the table.

The supported types of columns depend on the database backend. However,
all backends should support VARCHAR, INT, DOUBLE PRECISION and DATE.

The existing database connection(s) can be verified with *v.db.connect*.

## EXAMPLE

Adding a new attribute table with a single column to default layer 1:  

```sh
g.copy vect=roadsmajor,myroads
v.db.addtable myroads columns="slope double precision"
v.db.connect -p myroads
v.info -c myroads
```

Adding a new attribute table with two columns to layer 2:  

```sh
g.copy vect=roadsmajor,myroads
v.db.addtable myroads columns="slope double precision, roadname varchar(15)" layer=2
v.db.connect -p myroads
v.info -c myroads
v.info -c myroads layer=2
```

## SEE ALSO

*[db.connect](db.connect.md), [db.droptable](db.droptable.md),
[db.execute](db.execute.md), [v.db.connect](v.db.connect.md),
[v.db.dropcolumn](v.db.dropcolumn.md),
[v.db.droptable](v.db.droptable.md), [v.db.select](v.db.select.md),
[v.db.update](v.db.update.md)*

*[GRASS SQL interface](sql.md)*

## AUTHOR

Markus Neteler

## SOURCE CODE

Available at: [v.db.addtable source code](https://github.com/OSGeo/grass/tree/main/scripts/v.db.addtable)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.db.addtable))  
Latest change: Monday Aug 11 18:59:23 2025 in commit [edc87a4](https://github.com/OSGeo/grass/commit/edc87a4920570efe1d80b06033a435fc2f419d8f)
