---
hide:
  - toc
---

# Topic: surface

| Tool | Description |
|--------|-------------|
| [r.contour](r.contour.md) | Produces a vector map of specified contours from a raster map. |
| [r.fill.stats](r.fill.stats.md) | Rapidly fills 'no data' cells (NULLs) of a raster map with interpolated values (IDW). |
| [r.fillnulls](r.fillnulls.md) | Fills no-data areas in raster maps using spline interpolation. |
| [r.random.surface](r.random.surface.md) | Generates random surface(s) with spatial dependence. |
| [r.resamp.bspline](r.resamp.bspline.md) | Performs bilinear or bicubic spline interpolation with Tykhonov regularization. |
| [r.surf.area](r.surf.area.md) | Prints estimation of surface area for raster map. |
| [r.surf.contour](r.surf.contour.md) | Generates surface raster map from rasterized contours. |
| [r.surf.fractal](r.surf.fractal.md) | Creates a fractal surface of a given fractal dimension. |
| [r.surf.gauss](r.surf.gauss.md) | Generates a raster map using gaussian random number generator. Mean and standard deviation of gaussian deviates can be expressed by the user. |
| [r.surf.idw](r.surf.idw.md) | Provides surface interpolation from raster point data by Inverse Distance Squared Weighting. |
| [r.surf.random](r.surf.random.md) | Produces a raster surface map of uniform random deviates with defined range. |
| [v.surf.bspline](v.surf.bspline.md) | Performs bicubic or bilinear spline interpolation with Tykhonov regularization. |
| [v.surf.idw](v.surf.idw.md) | Provides surface interpolation from vector point data by Inverse Distance Squared Weighting. |
| [v.surf.rst](v.surf.rst.md) | Performs surface interpolation from vector points map by splines. Spatial approximation and topographic analysis from given point or isoline data in vector format to floating point raster format using regularized spline with tension. |

*See also the corresponding keyword for additional references:*

<!-- topic_keyword { include: [surface] } -->
