---
name: t.unregister.py
description: Unregisters raster, vector and raster3d maps from the temporal database or a specific space time dataset.
keywords: [ temporal, map management, unregister, time ]
---

# t.unregister.py

Unregisters raster, vector and raster3d maps from the temporal database or a specific space time dataset.

=== "Command line"

    **t.unregister.py**
    [**input**=*name*]
    [**file**=*name*]
    [**type**=*name*]
    [**maps**=*name* [,*name*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.unregister.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.unregister.py***",
        **input**=*None*,
        **file**=*None*,
        **type**=*"raster"*,
        **maps**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.unregister.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_unregister_py*(**input**=*None*,
        **file**=*None*,
        **type**=*"raster"*,
        **maps**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_unregister_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time dataset  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with map names, one per line  
    **type**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raster, vector, raster_3d*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *raster*  
    **maps**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name(s) of existing raster, vector or raster3d map(s) to unregister  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with map names, one per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raster, vector, raster_3d*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *raster*  
    **maps** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name(s) of existing raster, vector or raster3d map(s) to unregister  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, map, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **file** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with map names, one per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raster, vector, raster_3d*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *raster*  
    **maps** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name(s) of existing raster, vector or raster3d map(s) to unregister  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, map, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *t.unregister* module is designed to unregister raster, 3D raster
and vector map layers from space time datasets and the temporal
database.

Map layer that should be unregistered from the temporal database can be
specified as a list of comma separated map names or using a text file,
that contains one map layer name per line. By default the map type that
should be unregistered is set to raster. The option*type* must be used
to specify 3D raster or vector map layer types.

## INPUT FILE FORMAT

Specification of map names:

```sh
a1
a2
a3
a4
a5
a6
```

### NOTE

In case the *input* option is used to specify a space time dataset the
maps are only unregistered from the space time dataset, but not from the
temporal database. The reason is that maps can be registered in multiple
space time datasets and there is a need to unregister them from a
specific STDS without affecting other STDS.

## EXAMPLE

In this example a precipitation map it is registered into temperature
dataset, so the wrong map will be unregister.

```sh

t.register -i type=raster input=tempmean_monthly@climate_2009_2012 \
    maps=2012_01_precip \
    start="2013-01-01" increment="1 month"

# We unregister raster map 2012_01_precip from a space time dataset,
# the raster maps are still present in the temporal database
t.unregister type=raster input=tempmean_monthly@climate_2009_2012 maps=2012_01_precip

# We unregister raster map 2012_01_precip from the temporal database, hence
# the time stamps are removed
t.unregister type=raster maps=2012_01_precip
```

## SEE ALSO

*[t.create](t.create.md), [t.info](t.info.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.unregister source code](https://github.com/OSGeo/grass/tree/main/temporal/t.unregister)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.unregister))  
Latest change: Tuesday Feb 25 01:48:02 2025 in commit [9013c3d](https://github.com/OSGeo/grass/commit/9013c3d897d7f4debcc23031c88eb6d3e7d1cc57)
