---
name: r3.support
description: Allows creation and/or modification of 3D raster map layer support files.
keywords: [ raster3d, metadata, voxel ]
---

# r3.support

Allows creation and/or modification of 3D raster map layer support files.

=== "Command line"

    **r3.support**
    [**-s**]
    **map**=*name*
    [**title**=*phrase*]
    [**history**=*phrase*]
    [**unit**=*string*]
    [**vunit**=*string*]
    [**source1**=*phrase*]
    [**source2**=*phrase*]
    [**description**=*phrase*]
    [**raster**=*string*]
    [**loadhistory**=*name*]
    [**savehistory**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.support map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.support***",
        **map**,
        **title**=*None*,
        **history**=*None*,
        **unit**=*None*,
        **vunit**=*None*,
        **source1**=*None*,
        **source2**=*None*,
        **description**=*None*,
        **raster**=*None*,
        **loadhistory**=*None*,
        **savehistory**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.support", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_support*(**map**,
        **title**=*None*,
        **history**=*None*,
        **unit**=*None*,
        **vunit**=*None*,
        **source1**=*None*,
        **source2**=*None*,
        **description**=*None*,
        **raster**=*None*,
        **loadhistory**=*None*,
        **savehistory**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_support(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map  
    **title**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for map title  
    **history**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to append to the next line of the map's metadata file  
    **unit**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The map data unit  
    **vunit**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The vertical unit of the map  
    **source1**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data source, line 1  
    **source2**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data source, line 2  
    **description**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data description or keyword(s)  
    **raster**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy category table  
    **loadhistory**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file from which to load history  
    **savehistory**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file in which to save history  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Update range  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for map title  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **history** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to append to the next line of the map's metadata file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **unit** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The map data unit  
    **vunit** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The vertical unit of the map  
    **source1** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data source, line 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **source2** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data source, line 2  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **description** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data description or keyword(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy category table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **loadhistory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file from which to load history  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **savehistory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file in which to save history  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update range  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for map title  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **history** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to append to the next line of the map's metadata file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **unit** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The map data unit  
    **vunit** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The vertical unit of the map  
    **source1** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data source, line 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **source2** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data source, line 2  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **description** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data description or keyword(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy category table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **loadhistory** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file from which to load history  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **savehistory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file in which to save history  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update range  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

**r3.support** allows the user to create and/or edit raster3d map
support information. Editing of raster3d map units, history, description
and title is supported.

## NOTES

Freeform metadata information is stored in a "`hist`" file which may be
appended to by using the **history** option. Currently this is limited
to text with a maximum line length of 78 characters. Any input larger
than this will be wrapped to the next line. All other metadata strings
available as standard options are limited to 79 characters.

## SEE ALSO

*[r.info](r3.info.md), [r.timestamp](r3.timestamp.md)*

## AUTHORS

Soeren Gebbert, vTI/AK, soerengebbert gmooglemail.com  
Based on r.support written by Micharl Shapiro, CERL and others

## SOURCE CODE

Available at: [r3.support source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.support)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.support))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
