---
name: r3.retile
description: Retiles an existing 3D raster map with user defined x, y and z tile size.
keywords: [ raster3d, tiling, voxel ]
---

# r3.retile

Retiles an existing 3D raster map with user defined x, y and z tile size.

=== "Command line"

    **r3.retile**
    [**-c**]
    **input**=*name*
    **output**=*name*
    [**tiledimension**=*XxYxZ*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.retile input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.retile***",
        **input**,
        **output**,
        **tiledimension**=*"default"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.retile", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_retile*(**input**,
        **output**,
        **tiledimension**=*"default"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_retile(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the retiled 3D raster map  
    **tiledimension**=*XxYxZ*  
    &nbsp;&nbsp;&nbsp;&nbsp;The dimensions of the tiles used in the output raster3d map (XxYxZ or default: 16x16x8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable tile caching  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the retiled 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **tiledimension** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The dimensions of the tiles used in the output raster3d map (XxYxZ or default: 16x16x8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *XxYxZ*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable tile caching  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the retiled 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **tiledimension** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The dimensions of the tiles used in the output raster3d map (XxYxZ or default: 16x16x8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *XxYxZ*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable tile caching  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r3.retile* writes a copy of an existing 3D raster map with a user
defined number of tiles in x, y and z direction. The precision and the
type of the original 3D raster map are used for the new retiled 3D
raster map.

## SEE ALSO

*[r3.cross.rast](r3.info.md), [r3.out.ascii](r3.out.ascii.md),
[g.region](g.region.md), [r.tile](r3.retile.md)*

## AUTHOR

Sören Gebbert

## SOURCE CODE

Available at: [r3.retile source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.retile)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.retile))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
