---
name: r.unpack.py
description: Imports a GRASS specific raster archive file (packed with r.pack) as a raster map
keywords: [ raster, import, copying ]
---

# r.unpack.py

Imports a GRASS specific raster archive file (packed with r.pack) as a raster map

=== "Command line"

    **r.unpack.py**
    [**-op**]
    **input**=*name.pack*
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.unpack.py input=name.pack
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.unpack.py***",
        **input**,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.unpack.py", input="name.pack")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_unpack_py*(**input**,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_unpack_py(input="name.pack")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name.pack* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input pack file  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (default: taken from input file internals)  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current projects's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has same coordinate reference system as the current project  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print projection information of input pack file and exit  
  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input pack file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name.pack*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (default: taken from input file internals)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current projects's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has same coordinate reference system as the current project  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print projection information of input pack file and exit  
  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input pack file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name.pack*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (default: taken from input file internals)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current projects's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has same coordinate reference system as the current project  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print projection information of input pack file and exit  
  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.unpack* allows unpacking raster maps packed by *[r.pack](r.pack.md)*.

## NOTES

Name of the raster map is determined by default from pack file
internals. Optionally the name can be given by **output** parameter.
Currently only 2D raster maps are supported.

## EXAMPLE

Pack up raster map *aspect* into *aspect.pack* file.

```sh
r.pack input=aspect
```

the raster map can be afterwards unpacked by

```sh
r.unpack input=aspect.pack
```

## SEE ALSO

*[r.pack](r.pack.md), [r.in.gdal](r.in.gdal.md), [v.pack](v.pack.md)*

## AUTHORS

Original Bash script written by Hamish Bowman, Otago University, New
Zealand as GRASS AddOns  
Converted to Python and updated for GRASS 7 by Martin Landa, CTU in
Prague, Czech Republic

## SOURCE CODE

Available at: [r.unpack source code](https://github.com/OSGeo/grass/tree/main/scripts/r.unpack)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.unpack))  
Latest change: Tuesday Nov 11 15:17:03 2025 in commit [59f1608](https://github.com/OSGeo/grass/commit/59f1608a354cb5e6c1a7a5cc477633b8632d1774)
