---
name: r.tileset.py
description: Produces tilings of the source projection for use in the destination region and projection.
keywords: [ raster, tiling ]
---

# r.tileset.py

Produces tilings of the source projection for use in the destination region and projection.

=== "Command line"

    **r.tileset.py**
    [**-gw**]
    [**region**=*string*]
    **sourceproj**=*string*
    [**sourcescale**=*string*]
    [**destproj**=*string*]
    [**destscale**=*string*]
    [**maxcols**=*integer*]
    [**maxrows**=*integer*]
    [**overlap**=*integer*]
    [**separator**=*character*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.tileset.py sourceproj=string
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r.tileset.py***",
        **region**=*None*,
        **sourceproj**,
        **sourcescale**=*"1"*,
        **destproj**=*None*,
        **destscale**=*None*,
        **maxcols**=*1024*,
        **maxrows**=*1024*,
        **overlap**=*0*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r.tileset.py", sourceproj="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_tileset_py*(**region**=*None*,
        **sourceproj**,
        **sourcescale**=*"1"*,
        **destproj**=*None*,
        **destscale**=*None*,
        **maxcols**=*1024*,
        **maxrows**=*1024*,
        **overlap**=*0*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_tileset_py(sourceproj="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **region**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of region to use instead of current region for bounds and resolution  
    **sourceproj**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Source projection  
    **sourcescale**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Conversion factor from units to meters in source projection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **destproj**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Destination projection, defaults to this location's projection  
    **destscale**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Conversion factor from units to meters in source projection  
    **maxcols**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of columns for a tile in the source projection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1024*  
    **maxrows**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of rows for a tile in the source projection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1024*  
    **overlap**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of cells tiles should overlap in each direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Output field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Produces shell script output  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Produces web map server query string output  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of region to use instead of current region for bounds and resolution  
    **sourceproj** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Source projection  
    **sourcescale** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Conversion factor from units to meters in source projection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **destproj** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Destination projection, defaults to this location's projection  
    **destscale** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Conversion factor from units to meters in source projection  
    **maxcols** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of columns for a tile in the source projection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1024*  
    **maxrows** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of rows for a tile in the source projection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1024*  
    **overlap** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of cells tiles should overlap in each direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Output field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *w*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Produces shell script output  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Produces web map server query string output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of region to use instead of current region for bounds and resolution  
    **sourceproj** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Source projection  
    **sourcescale** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Conversion factor from units to meters in source projection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **destproj** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Destination projection, defaults to this location's projection  
    **destscale** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Conversion factor from units to meters in source projection  
    **maxcols** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of columns for a tile in the source projection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1024*  
    **maxrows** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of rows for a tile in the source projection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1024*  
    **overlap** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of cells tiles should overlap in each direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Output field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *w*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Produces shell script output  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Produces web map server query string output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.tileset* generates sets of tiles in another projection that cover a
region in this projection with adequate resolution. By default the
current region and its resolution are used, the bounds and resolution of
another region can be used via the region option.

## NOTES

*r.tileset* does not make "optimal" tilings (as few tiles of the largest
size less than the maximums). This means that from latitude longitude
projection to an appropriate projection for a region, in the degenerate
case, it may create tiles demanding up to twice the necessary
information. Furthermore, generating a tiling near a divergant point of
a source projection, such as the poles of a cylindrical source
projections, results in divergence of the tile set.

Not generating "optimal" tilings may have another consequence; the
aspect ratio of cells in the destination region will not necessarily
carry over to the source region and generated tiles may have cells of
strange aspect ratios. This might be a problem for some map request
services presenting data in an inappropriate projection or with strict
constraints on cell aspect ratio.

## OUTPUT FORMAT

Each tile is listed on a separate line in the output. The lines are
formatted as follows:

```sh
5|125|45|175|80|100
```

This is the default output format. It is the tile's minimum x
coordinate, minimum y coordinate, maximum x coordinate, maximum y
coordinate, width in cells, and height in cells separated by the "\|"
character. The fields can be separated by a different character by
changing the fs option.

```sh
w=5;s=125;e=45;n=175;cols=80;rows=100;
```

This is output in a format convenient for setting variables in a shell
script.

```sh
bbox=5,125,45,175&width=80&height=100
```

This is output in a format convenient for requesting data from some http
services.

## EXAMPLES

Generates tiles in latitude longitude that cover the current region,
each tile will be less than 1024 cells high and 2048 cells across. The
bounds and sizes of tiles in the output are separated by \| (pipe):

```sh
r.tileset sourceproj=+init=epsg:4326 maxrows=1024 maxcols=2048
```

Generates tiles in latitude longitude projection that cover the named
region "ne-rio". The tiles will have 2 cells of overlap. The output
format will be strings like the bbox requests for WMS servers:

```sh
r.tileset sourceproj=+init=epsg:4326 overlap=2 -w region=ne-rio
```

Generates tiles in the coordinate reference system of the project
"IrishGrid". Each tile will be less than 300x400 cells in size, with 3
cells of overlap in the top and right sides of each tile. The output is
in a format where each line is in shell script style. The substitution
`` `g.proj -j project=IrishGrid` `` will only work in a unix style
shell:

```sh
r.tileset sourceproj="`g.proj -j project=IrishGrid`" maxrows=400 maxcols=300 overlap=3 -g
```

## KNOWN ISSUES

- *r.tileset* does not know about meridians that "wrap-around" in
  projections.

## AUTHORS

Cedric Shock  
Updated for GRASS 7 by Martin Landa, CTU in Prague, Czech Republic

## SOURCE CODE

Available at: [r.tileset source code](https://github.com/OSGeo/grass/tree/main/scripts/r.tileset)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.tileset))  
Latest change: Thursday May 22 03:42:15 2025 in commit [370bcb0](https://github.com/OSGeo/grass/commit/370bcb0490b421ac90b2dbe5766af9512cb08f92)
