---
name: r.tile
description: Splits a raster map into tiles.
keywords: [ raster, tiling ]
---

# r.tile

Splits a raster map into tiles.

=== "Command line"

    **r.tile**
    **input**=*name*
    **output**=*string*
    **width**=*integer*
    **height**=*integer*
    [**overlap**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.tile input=name output=string width=0 height=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.tile***",
        **input**,
        **output**,
        **width**,
        **height**,
        **overlap**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.tile", input="name", output="string", width=0, height=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_tile*(**input**,
        **output**,
        **width**,
        **height**,
        **overlap**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_tile(input="name", output="string", width=0, height=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output base name  
    **width**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles (columns)  
    **height**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles (rows)  
    **overlap**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap of tiles  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output base name  
    **width** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles (columns)  
    **height** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles (rows)  
    **overlap** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap of tiles  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output base name  
    **width** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles (columns)  
    **height** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles (rows)  
    **overlap** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap of tiles  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.tile* retiles an existing raster map with user defined x and y tile
size.

## NOTES

*r.tile* generates a separate raster for each tile. This is equivalent
to running *g.region* along with *r.resample* in a double loop.

The module can be used to split a large raster map into smaller tiles,
e.g. for further parallelized analysis on a cluster computing system.

The overlap is defined in rows/columns.

## EXAMPLE

Retiling example for the North Carolina DEM:

```sh
g.region raster=elevation -p
# rows:       1350
# cols:       1500

# generating 2 x 2 = 4 tiles (width=1500/2, height=rows/2)
r.tile input=elevation output=elev_tile width=750 height=675
```

creates 4 tiles with the prefix *elev_tile* (named: elev_tile-000-000,
elev_tile-000-001, elev_tile-001-000, ...).

## SEE ALSO

*[g.region](g.region.md), [r3.retile](r3.retile.md)*

## AUTHOR

Glynn Clements

## SOURCE CODE

Available at: [r.tile source code](https://github.com/OSGeo/grass/tree/main/raster/r.tile)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.tile))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
