---
name: r.rescale
description: Rescales the range of category values in a raster map layer.
keywords: [ raster, rescale ]
---

# r.rescale

Rescales the range of category values in a raster map layer.

=== "Command line"

    **r.rescale**
    **input**=*name*
    [**from**=*min,max*]
    **output**=*name*
    **to**=*min,max*
    [**title**=*phrase*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.rescale input=name output=name to=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.rescale***",
        **input**,
        **from**=*None*,
        **output**,
        **to**,
        **title**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.rescale", input="name", output="name", to=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_rescale*(**input**,
        **from**=*None*,
        **output**,
        **to**,
        **title**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_rescale(input="name", output="name", to=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the raster map to be rescaled  
    **from**=*min,max*  
    &nbsp;&nbsp;&nbsp;&nbsp;The input data range to be rescaled (default: full range of input map)  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The resulting raster map name  
    **to**=*min,max* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The output data range  
    **title**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for new raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the raster map to be rescaled  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **from** : tuple[int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The input data range to be rescaled (default: full range of input map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The resulting raster map name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **to** : tuple[int, int] | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The output data range  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for new raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the raster map to be rescaled  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **from** : tuple[int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The input data range to be rescaled (default: full range of input map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The resulting raster map name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **to** : tuple[int, int] | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The output data range  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for new raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.rescale* program rescales the range of category values appearing
in a raster map layer. A new raster map layer, and an appropriate
category file and color table based upon the original raster map layer,
are generated with category labels that reflect the original category
values that produced each category. This command is useful for producing
representations with a reduced number of categories from a raster map
layer with a large range of category values (e.g., elevation).
*Rescaled* map layers are appropriate for use in such GRASS commands
as *[r.stats](r.stats.md)*, *[r.report](r.report.md)*, and
*[r.coin](r.coin.md)*.

## EXAMPLE

To rescale an elevation raster map layer with category values ranging
from 1090 meters to 1800 meters into the range 0-255, the following
command line could be used (without the *from* parameter, the full value
range will be used):

```sh
r.rescale input=elevation from=1090,1800 output=elevation.255 to=0,255
```

## NOTES

Category values that fall beyond the input range will become NULL. This
allows the user to select a subset of the full category value range for
rescaling if desired. This also means that the user should know the
category value range for the input raster map layer. The user can
request the *r.rescale* program to determine this range, or can obtain
it using the *[r.describe](r.describe.md)* or *[r.info](r.info.md)*
command. If the category value range is determined using *r.rescale*,
the input raster map layer is examined, and the minimum and maximum
non-NULL category values are selected as the input range.

## SEE ALSO

*[r.coin](r.coin.md), [r.describe](r.describe.md), [r.info](r.info.md),
[r.mapcalc](r.mapcalc.md), [r.reclass](r.reclass.md),
[r.rescale.eq](r.rescale.eq.md), [r.report](r.report.md),
[r.resample](r.resample.md), [r.stats](r.stats.md),
[r.univar](r.univar.md)*

## AUTHOR

Michael Shapiro, U.S.Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [r.rescale source code](https://github.com/OSGeo/grass/tree/main/raster/r.rescale)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.rescale))  
Latest change: Wednesday May 21 09:11:03 2025 in commit [4510205](https://github.com/OSGeo/grass/commit/45102055f4f205276ad5f85b5775b70c6583a26f)
