---
name: r.out.bin
description: Exports a GRASS raster to a binary array.
keywords: [ raster, export, output ]
---

# r.out.bin

Exports a GRASS raster to a binary array.

=== "Command line"

    **r.out.bin**
    [**-ifhbs**]
    **input**=*string*
    [**output**=*string*]
    [**null**=*float*]
    [**bytes**=*integer*]
    [**order**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.out.bin input=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.out.bin***",
        **input**,
        **output**=*None*,
        **null**=*0*,
        **bytes**=*None*,
        **order**=*"native"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.out.bin", input="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_out_bin*(**input**,
        **output**=*None*,
        **null**=*0*,
        **bytes**=*None*,
        **order**=*"native"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_out_bin(input="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output binary map (use output=- for stdout)  
    **null**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to write out for null  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bytes**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bytes per cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 2, 4, 8*  
    **order**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output byte order  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *big, little, native, swap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *native*  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate integer output  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate floating-point output  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Export array with GMT compatible header  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate BIL world and header files  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Byte swap output  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output binary map (use output=- for stdout)  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to write out for null  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bytes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bytes per cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 2, 4, 8*  
    **order** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output byte order  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *big, little, native, swap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *native*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *f*, *h*, *b*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate integer output  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate floating-point output  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export array with GMT compatible header  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate BIL world and header files  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Byte swap output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output binary map (use output=- for stdout)  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to write out for null  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bytes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bytes per cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 2, 4, 8*  
    **order** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output byte order  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *big, little, native, swap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *native*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *f*, *h*, *b*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate integer output  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate floating-point output  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export array with GMT compatible header  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate BIL world and header files  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Byte swap output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.out.bin* program exports a GRASS raster map to a binary array
file. Optionally, output can be sent to standard output (stdout) for
direct input (pipe) into other applications. Data is exported according
to the original GRASS raster type (e.g. float). If the "-i" flag is
specified, an integer array is output. The region parameters are printed
to stderr.

## NOTES

With the -h flag, data can be directly used by
[GMT](https://www.generic-mapping-tools.org/) as Grid Format 1 (float)
or 2 (short). For example:

```sh
r.out.bin -h input=grass.raster output=new.grd
grdinfo new.grd=1 (if float)
```

Exported data can be piped directly into the GMT program xyz2grd.

```sh
r.out.bin input=grass.raster output=- | xyz2grd -R....  -ZTLf -
```

The example uses the GMT program xyz2grd with the -ZTLf flag indicating
that a float array was output.

## SEE ALSO

*[r.in.bin](r.in.bin.md), [r.in.ascii](r.in.ascii.md),
[r.in.gdal](r.in.gdal.md), [r.out.ascii](r.out.ascii.md)*

## AUTHOR

This program is derived from *[r.out.ascii](r.out.ascii.md)* with a few
modifications.  
Author: [Bob Covill](mailto:bcovill@tekmap.ns.ca)

## SOURCE CODE

Available at: [r.out.bin source code](https://github.com/OSGeo/grass/tree/main/raster/r.out.bin)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.out.bin))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
