---
name: r.li.cwed
description: Calculates contrast weighted edge density index on a raster map
keywords: [ raster, landscape structure analysis, patch index ]
---

# r.li.cwed

Calculates contrast weighted edge density index on a raster map

=== "Command line"

    **r.li.cwed**
    **input**=*name*
    **config**=*name*
    **path**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.li.cwed input=name config=name path=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.li.cwed***",
        **input**,
        **config**,
        **path**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.li.cwed", input="name", config="name", path="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_li_cwed*(**input**,
        **config**,
        **path**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_li_cwed(input="name", config="name", path="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **config**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Configuration file  
    **path**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file that contains the weight to calculate the index  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **config** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Configuration file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **path** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file that contains the weight to calculate the index  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **config** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Configuration file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **path** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file that contains the weight to calculate the index  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.li.cwed* (contrast weighted edge density) calculates the edge density
between patch types specified:

![rlicwed formula](rlicwed_formula.png)

with:

- **k**: attribute
- **m**: number of non-null attributes in the sampling area
- **e_ik**: total
  length of edge in landscape between patch types i and k
- **d_ik**:
  dissimilarity (edge contrast weight) between patch types i and k
- **Area**: total landscape area

The input file contains a row for each couple of patch type that we want
to consider in the calculation. Each row must be saved using this
syntax:

```sh
patchType1,patchType2,dissimilarityBetweenPatchType1andPatchType2
```

## NOTES

Do not use absolute path names for the **config** and **output**
file/map parameters. If the "moving window" method was selected in
**g.gui.rlisetup**, then the output will be a raster map, otherwise an
ASCII file will be generated in the folder
`C:\Users\userxy\AppData\Roaming\GRASS8\r.li\output\` (MS-Windows) or
`$HOME/.grass8/r.li/output/` (GNU/Linux).

If the sample area contains only NULL values it is considered to have 0
patch and CWED=0. If Area is 0 *r.li.cwed* returns -1. This is only
possible if the map is masked.  
If you want to change these -1 values to NULL, run subsequently on the
resulting map:

```sh
r.null setnull=-1 input=my_map
```

after index calculation.

## EXAMPLES

To calculate the contrast weighted edge density index on map *my_map*,
using *my_conf* configuration file (previously defined with
*g.gui.rlisetup*) and saving results in *my_out*, run:

```sh
r.li.cwed input=my_map conf=my_conf output=my_out \
          path=/path/to/weights.csv
```

Example for input "weights.csv" file:

```sh
12,16,0.65
44,123,0.32
56,12,0.54
23,66,0.99
```

## SEE ALSO

*[r.li](r.li.md) (package overview),
[g.gui.rlisetup](g.gui.rlisetup.md)*

## REFERENCES

McGarigal, K., and B. J. Marks. 1995. FRAGSTATS: spatial pattern
analysis program for quantifying landscape structure. USDA For. Serv.
Gen. Tech. Rep. PNW-351. ([PDF](https://doi.org/10.2737/PNW-GTR-351))

## AUTHORS

Serena Pallecchi, student of Computer Science University of Pisa
(Italy).  
Commission from Faunalia Pontedera (PI), Italy (<www.faunalia.it>)  
Markus Metz

## SOURCE CODE

Available at: [r.li.cwed source code](https://github.com/OSGeo/grass/tree/main/raster/r.li/r.li.cwed)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.li/r.li.cwed))  
Latest change: Tuesday Apr 29 06:19:47 2025 in commit [12f893b](https://github.com/OSGeo/grass/commit/12f893be22c8aeda9b048070dde6a4a230791e2a)
