---
name: r.in.poly
description: Creates raster maps from ASCII polygon/line/point data files.
keywords: [ raster, import ]
---

# r.in.poly

Creates raster maps from ASCII polygon/line/point data files.

=== "Command line"

    **r.in.poly**
    **input**=*name*
    **output**=*name*
    [**title**=*phrase*]
    [**type**=*string*]
    [**null**=*integer*]
    [**rows**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.in.poly input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.in.poly***",
        **input**,
        **output**,
        **title**=*None*,
        **type**=*"CELL"*,
        **null**=*None*,
        **rows**=*4096*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.in.poly", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_in_poly*(**input**,
        **output**,
        **title**=*None*,
        **type**=*"CELL"*,
        **null**=*None*,
        **rows**=*4096*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_in_poly(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file; or "-" to read from stdin  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **title**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *CELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    **null**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Integer representing NULL value data cell  
    **rows**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of rows to hold in memory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4096*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file; or "-" to read from stdin  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *CELL*  
    **null** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Integer representing NULL value data cell  
    **rows** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of rows to hold in memory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4096*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file; or "-" to read from stdin  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *CELL*  
    **null** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Integer representing NULL value data cell  
    **rows** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of rows to hold in memory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4096*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.in.poly* allows the creation of GRASS binary raster maps from ASCII
files in the current directory containing polygon, linear, and point
features.

The **input** file is an ASCII text file containing the polygon, linear,
and point feature definitions. The format of this file is described in
the *INPUT FORMAT* section below.

The number of raster **rows** to hold in memory is per default 4096.
This parameter allows users with less memory (or more) on their system
to control how much memory *r.in.poly* uses. Usually the default value
is fine.

## NOTES

The data will be imported using the current region settings to set the
new raster map's bounds and resolution. Any features falling outside the
current region will be cropped. The region settings are controlled with
the *g.region* module.

The format is a simplified version of the standard GRASS vector ASCII
format used by *v.in.ascii*.

Polygons are filled, i.e. they define an area.

### Input Format

The input format for the **input** file consists of sections describing
either polygonal areas, linear features, or point features. The basic
format is:

```sh
A                      <for polygonal areas>
    easting northing
    .
    .
    .
=   cat# label
L                      <for linear features>
    easting northing
    .
    .
    .
=   cat# label
P                      <for single cell point features>
    easting northing
=   cat# label
```

The `A` signals the beginning of a filled polygon. It must appear in the
first column. The `L` signals the beginning of a linear feature. It also
must appear in the first column. The `P` signals the beginning of a
single cell point feature. Again, it must appear in the first column.
The coordinates of the vertices of the polygon, or the coordinates
defining the linear or point feature follow and must have a space in the
first column and at least one space between the *easting* and the
*northing.* To give meaning to the features, the "`=`" indicates that
the feature currently being processed has category value *cat#* (which
must be an integer) and a *label* (which may be more than one word, or
which may be omitted).

## EXAMPLE

An area described by four points:

```sh
A
  591316.80   4926455.50
  591410.25   4926482.40
  591434.60   4926393.60
  591341.20   4926368.70
= 42 stadium
```

## SEE ALSO

*[r.colors](r.colors.md), [d.rast.edit](d.rast.edit.md),
[g.region](g.region.md), [r.in.xyz](r.in.xyz.md), [r.patch](r.patch.md),
[v.in.ascii](v.in.ascii.md), [wxGUI vector digitizer](wxGUI.vdigit.md)*

## AUTHOR

Michael Shapiro, U.S.Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [r.in.poly source code](https://github.com/OSGeo/grass/tree/main/raster/r.in.poly)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.in.poly))  
Latest change: Friday Mar 07 07:39:48 2025 in commit [e1e37d8](https://github.com/OSGeo/grass/commit/e1e37d87e78212dfcf4c97aaf32c54042adbd2b0)
