---
name: r.cross
description: Creates a cross product of the category values from multiple raster map layers.
keywords: [ raster, statistics ]
---

# r.cross

Creates a cross product of the category values from multiple raster map layers.

=== "Command line"

    **r.cross**
    [**-z**]
    **input**=*string* [,*string*,...]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.cross input=string output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.cross***",
        **input**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.cross", input="string", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_cross*(**input**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_cross(input="string", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of 2-30 input raster maps  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Non-NULL data only  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of 2-30 input raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Non-NULL data only  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of 2-30 input raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Non-NULL data only  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.cross* creates an *output* raster map layer representing all unique
combinations of category values in the raster input layers
(**input**=*name,name,name*, ...). At least two, but not more than 30,
*input* map layers must be specified. The user must also specify a name
to be assigned to the *output* raster map layer created by *r.cross*.

## OPTIONS

With the **-z** flag NULL values are not crossed. This means that if a
NULL value occurs in any input data layer, this combination is ignored,
even if other data layers contain non-NULL data. In the example given
below, use of the **-z** option would cause 3 categories to be generated
instead of 5.

If the **-z** flag is not specified, then map layer combinations in
which some values are NULL will be assigned a unique category value in
the resulting output map.

Category values in the new *output* map layer will be the cross-product
of the category values from these existing *input* map layers.

## EXAMPLE

For example, suppose that, using two raster map layers, the following
combinations occur:

```sh
          map1   map2
          ___________
          NULL    1
          NULL    2
           1      1
           1      2
           2      4
```

*r.cross* would produce a new raster map layer with 5 categories:

```sh
          map1   map2   output
          ____________________
          NULL    1       0
          NULL    2       1
           1      1       2
           1      2       3
           2      4       4
```

Note: The actual category value assigned to a particular combination in
the *result* map layer is dependent on the order in which the
combinations occur in the input map layer data and can be considered
essentially random. The example given here is illustrative only.

## SUPPORT FILES

The category file created for the *output* raster map layer describes
the combinations of input map layer category values which generated each
category. In the above example, the category labels would be:

```sh
          category   category
          value      label
          ______________________________
             0       layer1(0) layer2(1)
             1       layer1(0) layer2(2)
             2       layer1(1) layer2(1)
             3       layer1(1) layer2(2)
             4       layer1(2) layer2(4)
```

A random color table is also generated for the *output* map layer.

## SEE ALSO

*[r.covar](r.covar.md), [r.stats](r.stats.md)*

## AUTHOR

Michael Shapiro, U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [r.cross source code](https://github.com/OSGeo/grass/tree/main/raster/r.cross)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.cross))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
