---
name: i.ortho.transform
description: Computes a coordinate transformation based on the control points.
keywords: [ imagery, orthorectify, transformation, GCP ]
---

# i.ortho.transform

Computes a coordinate transformation based on the control points.

=== "Command line"

    **i.ortho.transform**
    [**-srxp**]
    **group**=*name*
    [**format**=*string* [,*string*,...]]
    [**coords**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.ortho.transform group=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.ortho.transform***",
        **group**,
        **format**=*"fd,rd"*,
        **coords**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.ortho.transform", group="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_ortho_transform*(**group**,
        **format**=*"fd,rd"*,
        **coords**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_ortho_transform(group="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **format**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *idx, src, dst, fwd, rev, fxy, rxy, fd, rd*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fd,rd*  
    &nbsp;&nbsp;&nbsp;&nbsp;**idx**: point index  
    &nbsp;&nbsp;&nbsp;&nbsp;**src**: source coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**dst**: destination coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**fwd**: forward coordinates (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rev**: reverse coordinates (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;**fxy**: forward coordinates difference (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rxy**: reverse coordinates difference (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;**fd**: forward error (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rd**: reverse error (source)  
    **coords**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing coordinates to transform ("-" to read from stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Local x,y,z coordinates to target east,north,height  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display summary information  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reverse transform of coords file or coeff. dump  
    &nbsp;&nbsp;&nbsp;&nbsp;Target east,north,height coordinates to local x,y,z  
    **-x**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display transform matrix coefficients  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Enable panorama camera correction  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **format** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *idx, src, dst, fwd, rev, fxy, rxy, fd, rd*  
    &nbsp;&nbsp;&nbsp;&nbsp;**idx**: point index  
    &nbsp;&nbsp;&nbsp;&nbsp;**src**: source coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**dst**: destination coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**fwd**: forward coordinates (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rev**: reverse coordinates (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;**fxy**: forward coordinates difference (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rxy**: reverse coordinates difference (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;**fd**: forward error (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rd**: reverse error (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fd,rd*  
    **coords** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing coordinates to transform ("-" to read from stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Local x,y,z coordinates to target east,north,height  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *r*, *x*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display summary information  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse transform of coords file or coeff. dump  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Target east,north,height coordinates to local x,y,z  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display transform matrix coefficients  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Enable panorama camera correction  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **format** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *idx, src, dst, fwd, rev, fxy, rxy, fd, rd*  
    &nbsp;&nbsp;&nbsp;&nbsp;**idx**: point index  
    &nbsp;&nbsp;&nbsp;&nbsp;**src**: source coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**dst**: destination coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**fwd**: forward coordinates (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rev**: reverse coordinates (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;**fxy**: forward coordinates difference (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rxy**: reverse coordinates difference (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;**fd**: forward error (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rd**: reverse error (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fd,rd*  
    **coords** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing coordinates to transform ("-" to read from stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Local x,y,z coordinates to target east,north,height  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *r*, *x*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display summary information  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse transform of coords file or coeff. dump  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Target east,north,height coordinates to local x,y,z  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display transform matrix coefficients  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Enable panorama camera correction  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.ortho.transform* is an utility to compute transformation based upon
GCPs and output error measurements.

If coordinates are given with the **input** file option or fed from
`stdin`, both the input and the output format is "x y z" with one
coordinate pair per line. Reverse transform is performed with the **-r**
flag.

The **format** option determines how control points are printed out. A
summary on the control points can be printed with the **-s** flag. The
summary includes maximum deviation observed when transforming GCPs and
overall RMS. The **format** option is ignored when coordinates are given
with the **input** file option.

## NOTES

Ortho-transformation is a 2-step transformation. First, source
coordinates are transformed to sensor coordinates, then sensor
coordinates are transformed to target coordinates.

## SEE ALSO

*[i.rectify](i.rectify.md)*

## TODO

Update this document with x,y,z\<-\>E,N,H information

## AUTHORS

Brian J. Buckley  
Glynn Clements  
Hamish Bowman

## SOURCE CODE

Available at: [i.ortho.transform source code](https://github.com/OSGeo/grass/tree/main/imagery/i.ortho.photo/i.ortho.transform)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.ortho.photo/i.ortho.transform))  
Latest change: Thursday May 08 14:35:40 2025 in commit [9528b1e](https://github.com/OSGeo/grass/commit/9528b1e38ba37992c1597a979dc3efbb07b74ec5)
