---
name: g.list
description: Lists available GRASS data base files of the user-specified data type optionally using the search pattern.
keywords: [ general, map management, list, search ]
---

# g.list

Lists available GRASS data base files of the user-specified data type optionally using the search pattern.

=== "Command line"

    **g.list**
    [**-iretmpf**]
    **type**=*datatype* [,*datatype*,...]
    [**pattern**=*string*]
    [**exclude**=*string*]
    [**mapset**=*name* [,*name*,...]]
    [**separator**=*character*]
    [**region**=*name*]
    [**output**=*name*]
    [**format**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.list type=raster
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***g.list***",
        **type**,
        **pattern**=*None*,
        **exclude**=*None*,
        **mapset**=*None*,
        **separator**=*"newline"*,
        **region**=*None*,
        **output**=*None*,
        **format**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("g.list", type="raster", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_list*(**type**,
        **pattern**=*None*,
        **exclude**=*None*,
        **mapset**=*None*,
        **separator**=*"newline"*,
        **region**=*None*,
        **output**=*None*,
        **format**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_list(type="raster", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **type**=*datatype* [,*datatype*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raster, raster_3d, vector, label, region, group, all*  
    &nbsp;&nbsp;&nbsp;&nbsp;**raster**: raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**raster_3d**: 3D raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**vector**: vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**label**: paint label file(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: region definition(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**group**: imagery group(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**all**: all types  
    **pattern**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map name search pattern (default: all)  
    **exclude**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map name exclusion pattern (default: none)  
    **mapset**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset to list (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;'.' for current mapset; '\*' for all mapsets in location  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *newline*  
    **region**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of saved region for map search (default: not restricted)  
    &nbsp;&nbsp;&nbsp;&nbsp;'.' for current region; '\*' for default region  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given or '-' then standard output  
    **format**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore case  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use basic regular expressions instead of wildcards  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use extended regular expressions instead of wildcards  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print data types  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print fully-qualified map names (including mapsets)  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Pretty printing in human readable format [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. The plain format will become the default. Use format="plain" to set it explicitly in a script.  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose listing (also list map titles) [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release.  Use the type-specific tool to obtain metadata, such as r.info and v.info.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **type** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *datatype*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raster, raster_3d, vector, label, region, group, all*  
    &nbsp;&nbsp;&nbsp;&nbsp;**raster**: raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**raster_3d**: 3D raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**vector**: vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**label**: paint label file(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: region definition(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**group**: imagery group(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**all**: all types  
    **pattern** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map name search pattern (default: all)  
    **exclude** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map name exclusion pattern (default: none)  
    **mapset** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset to list (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;'.' for current mapset; '\*' for all mapsets in location  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *newline*  
    **region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of saved region for map search (default: not restricted)  
    &nbsp;&nbsp;&nbsp;&nbsp;'.' for current region; '\*' for default region  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given or '-' then standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *r*, *e*, *t*, *m*, *p*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore case  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use basic regular expressions instead of wildcards  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use extended regular expressions instead of wildcards  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print data types  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print fully-qualified map names (including mapsets)  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pretty printing in human readable format [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. The plain format will become the default. Use format="plain" to set it explicitly in a script.  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Verbose listing (also list map titles) [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release.  Use the type-specific tool to obtain metadata, such as r.info and v.info.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **type** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *datatype*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raster, raster_3d, vector, label, region, group, all*  
    &nbsp;&nbsp;&nbsp;&nbsp;**raster**: raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**raster_3d**: 3D raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**vector**: vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**label**: paint label file(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: region definition(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**group**: imagery group(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**all**: all types  
    **pattern** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map name search pattern (default: all)  
    **exclude** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map name exclusion pattern (default: none)  
    **mapset** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset to list (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;'.' for current mapset; '\*' for all mapsets in location  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *newline*  
    **region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of saved region for map search (default: not restricted)  
    &nbsp;&nbsp;&nbsp;&nbsp;'.' for current region; '\*' for default region  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given or '-' then standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *r*, *e*, *t*, *m*, *p*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore case  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use basic regular expressions instead of wildcards  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use extended regular expressions instead of wildcards  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print data types  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print fully-qualified map names (including mapsets)  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pretty printing in human readable format [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. The plain format will become the default. Use format="plain" to set it explicitly in a script.  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Verbose listing (also list map titles) [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release.  Use the type-specific tool to obtain metadata, such as r.info and v.info.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.list* searches for data files matching a pattern given by wildcards
or POSIX Extended Regular Expressions.

## NOTES

The output of *g.list* may be useful for other programs' parameter input
(e.g. time series for *[r.series](r.series.md)*) when used with
*separator=comma*.

The flags `-m` and `-t` apply only to shell format output.

The flags `-p` and `-f` apply only to plain format output, but they are now
deprecated and will be removed in a future release. Instead of using those, use
`format="plain"` to obtain human-readable, plain text output. The plain format
will become the default in a future release.

To obtain machine readable output use `format="shell"` or `format="json"`.

## EXAMPLES

List all raster maps as continuous, sorted list:

```sh
g.list type=rast
```

List all vector maps as continuous, sorted list with MAPSET info (i.e.
fully-qualified map names):

```sh
g.list type=vector -m
```

List all raster and vector maps grouped by mapset in plain format:

```sh
g.list type=raster,vector -p
```

List all raster and vector maps as continuous, sorted list:

```sh
g.list type=rast,vect
```

List all available GRASS data base files:

```sh
g.list type=all
```

List all raster and vector maps using Python:

```python
import grass.script as gs

data = gs.parse_command("g.list", type=["raster", "vector"], format="json")
print(data)
```

Possible output:

```text
[{'name': 'aspect', 'mapset': 'PERMANENT', 'type': 'raster', 'fullname': 'aspect@PERMANENT'}, {'name': 'zipcodes_wake', 'mapset': 'PERMANENT', 'type': 'vector', 'fullname': 'zipcodes_wake@PERMANENT'}]
```

### Mapset search path

If **mapset** is not specified, then *g.list* searches for data files in
the mapsets that are included in the search path (defined by
*[g.mapsets](g.mapsets.md)*). See `g.mapsets -p`.

```sh
g.list rast -p

raster map(s) available in mapset <user1>:
dmt
...
raster map(s) available in mapset <PERMANENT>:
aspect
...
```

Option **mapset**=. (one dot) lists only data files from the current
mapset:

```sh
g.list rast mapset=.
...
```

Similarly, **mapset**=\* (one asterisk) prints data files from all
available mapsets also including those that are not listed in the
current search path (see `g.mapsets -l`).

```sh
g.list rast mapset=* -p

raster map(s) available in mapset <landsat>:
lsat5_1987_10
...
raster map(s) available in mapset <user1>:
dmt
...
raster map(s) available in mapset <PERMANENT>:
aspect
...
```

### Wildcards

List all vector maps starting with letter "r":

```sh
g.list type=vector pattern="r*"
```

List all vector maps starting with letter "r" or "a":

```sh
g.list type=vector pattern="[ra]*"
```

List all raster maps starting with "soil\_" or "landuse\_":

```sh
g.list type=raster pattern="{soil,landuse}_*"
```

List certain raster maps with one variable character/number:

```sh
g.list type=raster pattern="N45E00?.meters"
```

Use of **exclude** parameter:

```sh
# without exclude:
  g.list rast pat="r*" mapset=PERMANENT
  railroads
  roads
  rstrct.areas
  rushmore

# exclude only complete word(s):
  g.list rast pat="r*" exclude=roads mapset=PERMANENT
  railroads
  rstrct.areas
  rushmore

# exclude with wildcard:
  g.list rast pat="r*" exclude="*roads*" mapset=PERMANENT
  rstrct.areas
  rushmore
```

### Regular expressions

List all soil maps starting with "soils" in their name:

```sh
g.list -r type=raster pattern='^soils'
```

List "tmp" if "tmp" raster map exists:

```sh
g.list -r type=raster pattern='^tmp$'
```

List "tmp0" ..."tmp9" if corresponding vector map exists (each map name
linewise):

```sh
g.list -r type=vector pattern='^tmp[0-9]$'
```

List "tmp0"..."tmp9" if corresponding vector map exists (each map name
comma separated):

```sh
g.list -r type=vector separator=comma pattern='^tmp[0-9]$'
```

### Extended regular expressions

List all precipitation maps for the years 1997-2012, comma separated:

```sh
g.list -e type=raster separator=comma pattern="precip_total.(199[7-9]|200[0-9]|201[0-2]).sum"
```

### Maps whose region overlaps with a saved region

List all raster maps starting with "tmp\_" whose region overlaps with
the region of "test" raster map:

```sh
g.region raster=test save=test_region
g.list type=raster pattern='tmp_*' region=test_region
```

List "tmp0"..."tmp9" vector maps whose region overlaps with the current
region:

```sh
g.list -r type=vector pattern='^tmp[0-9]$' region=.
```

List all raster and vector maps whose region overlaps with the default
region of the PERMANENT mapset in the current project (DEFAULT_WIND):

```sh
g.list type=rast,vect region=*
```

Note that, without `region=*`, `g.list type=rast,vect` simply lists all
available raster and vector maps from the current search path regardless
of their region.

## SEE ALSO

*[r.series](r.series.md), [t.list](t.list.md),
[t.rast.list](t.rast.list.md), [t.vect.list](t.vect.list.md)*

[Regular expressions](https://en.wikipedia.org/wiki/Regular_expression)
(aka regex) - from Wikipedia, the free encyclopedia

## AUTHOR

Huidae Cho  
<grass4u@gmail.com>  
based on general/manage/cmd/list.c by Michael Shapiro

## SOURCE CODE

Available at: [g.list source code](https://github.com/OSGeo/grass/tree/main/general/g.list)
([history](https://github.com/OSGeo/grass/commits/main/general/g.list))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
