---
name: v.parallel
description: Creates parallel line to input vector lines.
keywords: [ vector, geometry, buffer, line ]
---

# v.parallel

Creates parallel line to input vector lines.

=== "Command line"

    **v.parallel**
    [**-rb**]
    **input**=*name*
    [**layer**=*string*]
    **output**=*name*
    **distance**=*float*
    [**minordistance**=*float*]
    [**angle**=*float*]
    **side**=*string*
    [**tolerance**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.parallel input=name output=name distance=0.0 side=right
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.parallel***",
        **input**,
        **layer**=*"-1"*,
        **output**,
        **distance**,
        **minordistance**=*None*,
        **angle**=*0*,
        **side**=*"right"*,
        **tolerance**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.parallel", input="name", output="name", distance=0.0, side="right")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_parallel*(**input**,
        **layer**=*"-1"*,
        **output**,
        **distance**,
        **minordistance**=*None*,
        **angle**=*0*,
        **side**=*"right"*,
        **tolerance**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_parallel(input="name", output="name", distance=0.0, side="right")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **distance**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset along major axis in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100000000*  
    **minordistance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset along minor axis in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100000000*  
    **angle**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of major axis in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **side**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Side  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *left, right, both*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *right*  
    &nbsp;&nbsp;&nbsp;&nbsp;**left**: Parallel line is on the left  
    &nbsp;&nbsp;&nbsp;&nbsp;**right**: Parallel line is on the right  
    &nbsp;&nbsp;&nbsp;&nbsp;**both**: Parallel lines on both sides  
    **tolerance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance of arc polylines in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100000000*  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Make outside corners round  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create buffer-like parallel lines  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **distance** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset along major axis in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100000000*  
    **minordistance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset along minor axis in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100000000*  
    **angle** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of major axis in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **side** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Side  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *left, right, both*  
    &nbsp;&nbsp;&nbsp;&nbsp;**left**: Parallel line is on the left  
    &nbsp;&nbsp;&nbsp;&nbsp;**right**: Parallel line is on the right  
    &nbsp;&nbsp;&nbsp;&nbsp;**both**: Parallel lines on both sides  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *right*  
    **tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance of arc polylines in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100000000*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Make outside corners round  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create buffer-like parallel lines  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **distance** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset along major axis in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100000000*  
    **minordistance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset along minor axis in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100000000*  
    **angle** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of major axis in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **side** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Side  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *left, right, both*  
    &nbsp;&nbsp;&nbsp;&nbsp;**left**: Parallel line is on the left  
    &nbsp;&nbsp;&nbsp;&nbsp;**right**: Parallel line is on the right  
    &nbsp;&nbsp;&nbsp;&nbsp;**both**: Parallel lines on both sides  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *right*  
    **tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance of arc polylines in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100000000*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Make outside corners round  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create buffer-like parallel lines  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.parallel* creates parallel lines to the input vector lines which can
be used as half-buffers.

## NOTES

Usage of **-b** flag will overrule the **side** parameter.

## KNOWN ISSUES

There is a problem with side-offset parallel line generation for inside
corners. To avoid this problem, the **-b** flag might be used.

## SEE ALSO

*[v.buffer](v.buffer.md)*

## AUTHORS

Radim Blazek  
Rewritten by Rosen Matev (with support through the Google Summer of Code
program 2008)

## SOURCE CODE

Available at: [v.parallel source code](https://github.com/OSGeo/grass/tree/main/vector/v.parallel)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.parallel))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
