---
name: v.label
description: Creates paint labels for a vector map from attached attributes.
keywords: [ vector, paint labels ]
---

# v.label

Creates paint labels for a vector map from attached attributes.

=== "Command line"

    **v.label**
    [**-ac**]
    [**labels**=*name*]
    **map**=*name*
    **column**=*name*
    [**type**=*string* [,*string*,...]]
    [**layer**=*string*]
    [**where**=*sql_query*]
    [**xoffset**=*float*]
    [**yoffset**=*float*]
    [**reference**=*string* [,*string*,...]]
    [**font**=*string*]
    [**size**=*float*]
    [**space**=*float*]
    [**fontsize**=*integer*]
    [**color**=*name*]
    [**rotation**=*angle*]
    [**width**=*float*]
    [**highlight_color**=*name*]
    [**highlight_width**=*float*]
    [**bgcolor**=*name*]
    [**border**=*name*]
    [**opaque**=*yes|no*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.label map=name column=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.label***",
        **labels**=*None*,
        **map**,
        **column**,
        **type**=*"point,line,boundary,centroid"*,
        **layer**=*"1"*,
        **where**=*None*,
        **xoffset**=*0*,
        **yoffset**=*0*,
        **reference**=*"center"*,
        **font**=*"standard"*,
        **size**=*100*,
        **space**=*None*,
        **fontsize**=*None*,
        **color**=*"black"*,
        **rotation**=*0*,
        **width**=*1*,
        **highlight_color**=*"none"*,
        **highlight_width**=*0*,
        **bgcolor**=*"none"*,
        **border**=*"none"*,
        **opaque**=*"yes"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.label", map="name", column="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_label*(**labels**=*None*,
        **map**,
        **column**,
        **type**=*"point,line,boundary,centroid"*,
        **layer**=*"1"*,
        **where**=*None*,
        **xoffset**=*0*,
        **yoffset**=*0*,
        **reference**=*"center"*,
        **font**=*"standard"*,
        **size**=*100*,
        **space**=*None*,
        **fontsize**=*None*,
        **color**=*"black"*,
        **rotation**=*0*,
        **width**=*1*,
        **highlight_color**=*"none"*,
        **highlight_width**=*0*,
        **bgcolor**=*"none"*,
        **border**=*"none"*,
        **opaque**=*"yes"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_label(map="name", column="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **labels**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new paint-label file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given the name of the input map is used  
    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be used for labels  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **xoffset**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset label in x-direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **yoffset**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset label in y-direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **reference**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference position  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *center, left, right, upper, lower*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *center*  
    **font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *standard*  
    **size**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (in map-units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **space**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Space between letters for curled labels (in map-units)  
    **fontsize**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (in points)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    **color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **rotation**=*angle*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotation angle in degrees (counter-clockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **width**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border width  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-25*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **highlight_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Highlight color for text  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **highlight_width**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of highlight coloring  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bgcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **border**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **opaque**=*yes|no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Opaque to vector (only relevant if background color is selected)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *yes, no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yes*  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotate labels to align with lines  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Curl labels along lines  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **labels** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new paint-label file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given the name of the input map is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be used for labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **xoffset** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset label in x-direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **yoffset** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset label in y-direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **reference** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference position  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *center, left, right, upper, lower*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *center*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *standard*  
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (in map-units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **space** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Space between letters for curled labels (in map-units)  
    **fontsize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (in points)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **rotation** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotation angle in degrees (counter-clockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *angle*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border width  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-25*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **highlight_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Highlight color for text  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **highlight_width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of highlight coloring  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **border** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **opaque** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Opaque to vector (only relevant if background color is selected)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *yes|no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *yes, no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yes*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Rotate labels to align with lines  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Curl labels along lines  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **labels** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new paint-label file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given the name of the input map is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be used for labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **xoffset** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset label in x-direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **yoffset** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset label in y-direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **reference** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference position  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *center, left, right, upper, lower*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *center*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *standard*  
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (in map-units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **space** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Space between letters for curled labels (in map-units)  
    **fontsize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (in points)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **rotation** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotation angle in degrees (counter-clockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *angle*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border width  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-25*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **highlight_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Highlight color for text  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **highlight_width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of highlight coloring  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **border** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **opaque** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Opaque to vector (only relevant if background color is selected)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *yes|no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *yes, no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yes*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Rotate labels to align with lines  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Curl labels along lines  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.label* makes a label-file from a GRASS vector map with labels created
from attributes in the attached table. If no label file name is given,
the name of the source map is used.

## NOTES

If the *fontsize* option is given then the *space* option is determined
automatically *from the current display window*, otherwise the *space*
option should be set roughly the same as the *size* option.

A description of the labels file follows.

The file is located in `$MAPSET/paint/labels/`. The file is a plain-text
ASCII file containing the following fields:

**TEXT**:  
Lines in multiple line labels will appear one above the next. More than
one line of text can be specified by notating the end of a line with a
'**`\n`**'.  
(e.g. `SPEARFISH`**`\n`**`SOUTH DAKOTA)`.

**LOCATION**:  
Determines where the text will be located on the image. The user
specifies the easting and northing, and (optionally) specifies a
vertical and horizontal offset from the specified easting/northing.
These offsets are provided to allow finer placement of labels and are
measured in local pixels. Thus in [*d.labels*](d.labels.md) the offset
is measured in screen pixels, and in [*ps.map*](ps.map.md) the offset is
measured in PostScript points (i.e. 1/72" steps).

**PLACEMENT**:  
Determines which part of the label to which the location refers. If
placement is unspecified, the label is centered (*center*), by default.
Label placement may be specified as:

```sh
    lower left    (lower left corner of the text)
    lower right    (lower right corner of the text)
    lower center    (bottom center of the text)

    upper left    (upper left corner of the text)
    upper right    (upper right corner of the text)
    upper center    (top center of the text)

    center    (center of the text)

```

**FONT**:  
This specifies the font to use.

The following fonts are available for use with
[*d.labels*](d.labels.md):

```sh
  cyrilc gothgbt gothgrt gothitt greekc greekcs greekp greeks
  italicc italiccs italict romanc romancs romand romans romant
  scriptc scripts
```

Alternatively the path to a FreeType (.ttf) font may be given. (for
*d.labels* only)

The word *standard* can be used to specify the default font (which is
*romans*).

Note [*ps.map*](ps.map.md) can override this setting to use other fonts.
Its default font is Helvetica.

**TEXT SIZE**:  
This determines the size of the letters. The *size* specifies the
vertical height of the letters in meters on the ground. Thus text will
grow or shrink depending on the scale at which the map is drawn.
Alternatively *fontsize* can set the font size in normal font points.

**TEXT COLOR**:  
This selects the text color. If unspecified, the label's text is drawn
in *black*, by default. The text color can be specified in one of
several ways:

1. By color name: *aqua*, *black*, *blue*, *brown*, *cyan*, *gray*,
   *green*, *grey*, *indigo*, *magenta*, *orange*, *purple*, *red*,
   *violet*, *white*, *yellow*
2. As red, green, blue component values. (0-255)  
    for example: `128:100:200`
3. Specify "`none`" to suppress the lettering.

**WIDTH**:  
This determines the line thickness of the border box.  
The maximum value is 25.0.

**HIGHLIGHT COLOR**:  
The text can be highlighted in another color so that it appears to be in
two colors. The text is drawn first in this color at a wider line width,
and then redrawn in the text color at the regular line width. No
highlight color ("`none`") is used by default, if unspecified by the
user. To specify use of no highlight color, specify "`none`". (See TEXT
COLOR above for a list of permissible color names.)

**HIGHLIGHT WIDTH**:  
Specifies how far from the text lines (in units of pixels) the highlight
color should extend. The default highlight width is set to *0* (i.e., no
highlight color).

**BACKGROUND COLOR**:  
Text may be boxed in a solid color by specifying a background color.
Specify "`none`" for no background. The default background color
setting, if unspecified by the user, is *white*. (See TEXT
COLOR above for a list of permissible color names.)

**BORDER COLOR**:  
Select a color for the border around the background. Specify "`none`" to
suppress the border. The default border color used, if unspecified, is
*black*. (See TEXT COLOR above for a list of permissible
color names.)

**OPAQUE TO VECTORS**:  
*yes\|no*. This field only has meaning if a background color is
selected. *yes* will prevent vector lines from entering the background.
*no* will allow vector lines to enter the background. The default
setting, if unspecified by the user, is *yes*.

## EXAMPLE

Spearfish example with TrueType font (path may differ):

```sh
v.label -a map=roads column=label labels=lroads \
        font=/usr/X11R6/lib/X11/fonts/TTF/luximri.ttf
d.vect roads
d.labels lroads
```

Since the label files are simple text files, you can merge them together
if you like. For example if you set the label colors based on database
attributes using multiple runs with the **where** option. This example
uses the standard UNIX `cat` program.

```sh
cd $MAPSET/paint/labels/
cat file1 file2 file3 file4 > file_all
```

## SEE ALSO

*[d.labels](d.labels.md), [ps.map](ps.map.md)*

## AUTHORS

Philip Verhagen (original s.label)  
Radim Blazek (GRASS 6 port)  
Hamish Bowman (enhancements)

## SOURCE CODE

Available at: [v.label source code](https://github.com/OSGeo/grass/tree/main/vector/v.label)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.label))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
