---
name: v.kcv
description: Randomly partition points into test/train sets.
keywords: [ vector, statistics, points, point pattern, sampling ]
---

# v.kcv

Randomly partition points into test/train sets.

=== "Command line"

    **v.kcv**
    **map**=*name*
    [**layer**=*string*]
    **npartitions**=*integer*
    [**column**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.kcv map=name npartitions=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.kcv***",
        **map**,
        **layer**=*"1"*,
        **npartitions**,
        **column**=*"part"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.kcv", map="name", npartitions=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_kcv*(**map**,
        **layer**=*"1"*,
        **npartitions**,
        **column**=*"part"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_kcv(map="name", npartitions=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **npartitions**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of partitions  
    &nbsp;&nbsp;&nbsp;&nbsp;Must be &gt; 1  
    **column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new column to which partition number is written  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *part*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **npartitions** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of partitions  
    &nbsp;&nbsp;&nbsp;&nbsp;Must be &gt; 1  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new column to which partition number is written  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *part*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **npartitions** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of partitions  
    &nbsp;&nbsp;&nbsp;&nbsp;Must be &gt; 1  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new column to which partition number is written  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *part*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.kcv* randomly divides a points lists into *k* sets of test/train data
(for **npartitions**-fold **c**ross **v**alidation). Test partitions are
mutually exclusive. That is, a point will appear in only one test
partition and *k-1* training partitions. The module generates a random
point using the selected random number generator and then finds the
closest point to it. This site is removed from the candidate list
(meaning that it will not be selected for any other test set) and saved
in the first test partition file. This is repeated until enough points
have been selected for the test partition. The number of points chosen
for test partitions depends upon the number of sites available and the
number of partitions chosen (this number is made as consistent as
possible while ensuring that all sites will be chosen for testing). This
process of filling up a test partition is done *k* times.

## NOTES

An ideal random sites generator will follow a Poisson distribution and
will only be as random as the original sites. This module simply divides
vector points up in a random manner.

Be warned that random number generation occurs over the intervals
defined by the current region of the map.

This program may not work properly with Lat-long data.

## EXAMPLES

All examples are based on the North Carolina sample dataset.

```sh
g.copy vect=geonames_wake,my_geonames_wake
v.kcv map=my_geonames_wake column=part npartitions=10
```

```sh
g.copy vect=geodetic_pts,my_geodetic_pts
v.kcv map=my_geodetic_pts column=part npartitions=10
```

## SEE ALSO

*[v.random](v.random.md), [g.region](g.region.md)*

## AUTHORS

James Darrell McCauley,  
when he was at: [Agricultural
Engineering](http://ABE.www.ecn.purdue.edu/ABE/) [Purdue
University](http://www.purdue.edu/)

27 Jan 1994: fixed RAND_MAX for Solaris 2.3  
13 Sep 2000: released under GPL  
Updated to 5.7 Radim Blazek 10 / 2004  
OGR support by Martin Landa (2009)  
Speed-up by Jan Vandrol and Jan Ruzicka (2013)

## SOURCE CODE

Available at: [v.kcv source code](https://github.com/OSGeo/grass/tree/main/vector/v.kcv)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.kcv))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
