---
hide:
  - toc
---

# Topic: landscape structure analysis

| Tool | Description |
|--------|-------------|
| [r.li.cwed](r.li.cwed.md) | Calculates contrast weighted edge density index on a raster map |
| [r.li.dominance](r.li.dominance.md) | Calculates dominance's diversity index on a raster map |
| [r.li.edgedensity](r.li.edgedensity.md) | Calculates edge density index on a raster map, using a 4 neighbour algorithm |
| [r.li.mpa](r.li.mpa.md) | Calculates mean pixel attribute index on a raster map |
| [r.li.mps](r.li.mps.md) | Calculates mean patch size index on a raster map, using a 4 neighbour algorithm |
| [r.li.padcv](r.li.padcv.md) | Calculates coefficient of variation of patch area on a raster map |
| [r.li.padrange](r.li.padrange.md) | Calculates range of patch area size on a raster map |
| [r.li.padsd](r.li.padsd.md) | Calculates standard deviation of patch area a raster map |
| [r.li.patchdensity](r.li.patchdensity.md) | Calculates patch density index on a raster map, using a 4 neighbour algorithm |
| [r.li.patchnum](r.li.patchnum.md) | Calculates patch number index on a raster map, using a 4 neighbour algorithm. |
| [r.li.pielou](r.li.pielou.md) | Calculates Pielou's diversity index on a raster map |
| [r.li.renyi](r.li.renyi.md) | Calculates Renyi's diversity index on a raster map |
| [r.li.richness](r.li.richness.md) | Calculates richness index on a raster map |
| [r.li.shannon](r.li.shannon.md) | Calculates Shannon's diversity index on a raster map |
| [r.li.shape](r.li.shape.md) | Calculates shape index on a raster map |
| [r.li.simpson](r.li.simpson.md) | Calculates Simpson's diversity index on a raster map |

*See also the corresponding keyword for additional references:*

<!-- topic_keyword { include: [landscape structure analysis] } -->
