---
name: t.vect.import.py
description: Imports a space time vector dataset from a GRASS specific archive file.
keywords: [ temporal, import, vector, time, create project ]
---

# t.vect.import.py

Imports a space time vector dataset from a GRASS specific archive file.

=== "Command line"

    **t.vect.import.py**
    [**-eoc**]
    **input**=*name*
    **output**=*name*
    [**basename**=*string*]
    **directory**=*name*
    [**title**=*string*]
    [**description**=*string*]
    [**project**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.vect.import.py input=name output=name directory=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.vect.import.py***",
        **input**,
        **output**,
        **basename**=*None*,
        **directory**,
        **title**=*None*,
        **description**=*None*,
        **project**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.vect.import.py", input="name", output="name", directory="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_vect_import_py*(**input**,
        **output**,
        **basename**=*None*,
        **directory**,
        **title**=*None*,
        **description**=*None*,
        **project**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_vect_import_py(input="name", output="name", directory="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time vector dataset  
    **basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **directory**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the extraction directory  
    **title**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title of the new space time dataset  
    **description**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Description of the new space time dataset  
    **project**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Create a new project (location) and import the data into it. Do not run this module in parallel or interrupt it when a new project should be created  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extend project extents based on new dataset  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current projects's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has same coordinate reference system as the current project  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create the project specified by the "project" parameter and exit. Do not import the space time vector datasets.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time vector dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, stvds, *name*  
    **basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **directory** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the extraction directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title of the new space time dataset  
    **description** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Description of the new space time dataset  
    **project** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Create a new project (location) and import the data into it. Do not run this module in parallel or interrupt it when a new project should be created  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *o*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend project extents based on new dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current projects's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has same coordinate reference system as the current project  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create the project specified by the "project" parameter and exit. Do not import the space time vector datasets.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time vector dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, stvds, *name*  
    **basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **directory** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the extraction directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title of the new space time dataset  
    **description** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Description of the new space time dataset  
    **project** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Create a new project (location) and import the data into it. Do not run this module in parallel or interrupt it when a new project should be created  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *o*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend project extents based on new dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current projects's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has same coordinate reference system as the current project  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create the project specified by the "project" parameter and exit. Do not import the space time vector datasets.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.vect.import* imports a space time vector dataset archive that was
exported with [t.vect.export](t.vect.export.md).

## NOTES

Optionally a base map name can be provided to avoid that existing vector
maps are overwritten by the map names that are used in the STRDS
archive.

The **directory** is used as work directory in case of import but can
also be used as a data directory when using GML for the data exchange.

## EXAMPLE

In this example, five vector maps are created and registered in a single
space time vector dataset named *random_locations*. Each vector map
represents random locations within the boundary of the state taken at 1
month intervals. The space time dataset is then exported and
re-imported.

```sh
db.connect -d

for i in `seq 1 5` ; do
    v.random output=map_$i n=500 restrict=boundary_state@PERMANENT
    echo map_$i >> map_list.txt
done

t.create type=stvds temporaltype=absolute \
         output=random_locations \
         title="Random locations" \
         description="Vector test dataset with random locations"

t.register -i type=vector input=random_locations \
           file=map_list.txt start="2012-01-01" increment="1 months"

t.vect.list random_locations

t.vect.export input=random_locations output=random_locations.tar.gz \
              compression=gzip

t.vect.import input=random_locations.tar.gz output=new_random_locations \
              basename=new_map directory=/tmp

t.vect.list new_random_locations
id|name|layer|mapset|start_time|end_time
new_map_1@user1|new_map_1|None|user1|2012-01-01 00:00:00|2012-02-01 00:00:00
new_map_2@user1|new_map_2|None|user1|2012-02-01 00:00:00|2012-03-01 00:00:00
new_map_3@user1|new_map_3|None|user1|2012-03-01 00:00:00|2012-04-01 00:00:00
new_map_4@user1|new_map_4|None|user1|2012-04-01 00:00:00|2012-05-01 00:00:00
new_map_5@user1|new_map_5|None|user1|2012-05-01 00:00:00|2012-06-01 00:00:00
```

## SEE ALSO

*[t.vect.export](t.vect.export.md), [t.create](t.create.md),
[t.info](t.info.md), [v.in.ogr](v.in.ogr.md), [v.pack](v.pack.md),
[t.rast.import](t.rast.import.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.vect.import source code](https://github.com/OSGeo/grass/tree/main/temporal/t.vect.import)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.vect.import))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
