<style>
.img-list {
    margin: 0;
    padding: 0;
    list-style-type: none;
}

.img-list li {
    padding: 5px;
    overflow: auto;
}

.img-list li:hover {
    background-color: #eee;
}

.img-list li a {
    color: initial;
    text-decoration: none;
    display: block;
}

.img-list li img {
    width: 10%;
    float: left;
    margin: 0 15px 0 0;
    background: white;
    object-fit: scale-down;
}

.img-list li img.default-img {
    max-height: 5ex;
    background-color: var(--gs-primary-color);
    padding: 5px;
}

.img-list li .desc {
    margin: 0px;
}

.img-list li .name {
    margin: 5px;
    display: block;
    color: #409940;
    font-weight: bold;
    font-style: italic;
}
</style>
Go to <a href="rasterintro.html">raster introduction</a> | <a href="topics.html">topics</a> <p>
# Raster tools
<ul class="img-list"><li><a href="r.basins.fill.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.basins.fill.html"><span class="name">r.basins.fill</span> <span class="desc">Generates watershed subbasins raster map.</span></a></li><li><a href="r.blend.html"><img class="linkimg" src="r_blend.png"></a><a href="r.blend.html"><span class="name">r.blend</span> <span class="desc">Blends color components of two raster maps by a given ratio.</span></a></li><li><a href="r.buffer.lowmem.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.buffer.lowmem.html"><span class="name">r.buffer.lowmem</span> <span class="desc">Creates a raster map showing buffer zones surrounding cells that contain non-NULL category values. This is the low-memory alternative to the classic r.buffer module.</span></a></li><li><a href="r.buffer.html"><img class="linkimg" src="r_buffer_road.png"></a><a href="r.buffer.html"><span class="name">r.buffer</span> <span class="desc">Creates a raster map showing buffer zones surrounding cells that contain non-NULL category values.</span></a></li><li><a href="r.buildvrt.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.buildvrt.html"><span class="name">r.buildvrt</span> <span class="desc">Build a VRT (Virtual Raster) from the list of input raster maps.</span></a></li><li><a href="r.carve.html"><img class="linkimg" src="r_carve_dem_orig.png"></a><a href="r.carve.html"><span class="name">r.carve</span> <span class="desc">Generates stream channels. Takes vector stream data, transforms it to raster and subtracts depth from the output DEM.</span></a></li><li><a href="r.category.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.category.html"><span class="name">r.category</span> <span class="desc">Manages category values and labels associated with user-specified raster map layers.</span></a></li><li><a href="r.circle.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.circle.html"><span class="name">r.circle</span> <span class="desc">Creates a raster map containing concentric rings around a given point.</span></a></li><li><a href="r.clump.html"><img class="linkimg" src="r_clump_lsat.png"></a><a href="r.clump.html"><span class="name">r.clump</span> <span class="desc">Recategorizes data in a raster map by grouping cells that form physically discrete areas into unique categories.</span></a></li><li><a href="r.coin.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.coin.html"><span class="name">r.coin</span> <span class="desc">Tabulates the mutual occurrence (coincidence) of categories for two raster map layers.</span></a></li><li><a href="r.colors.html"><img class="linkimg" src="r_colors_stddev.png"></a><a href="r.colors.html"><span class="name">r.colors</span> <span class="desc">Creates/modifies the color table associated with a raster map.</span></a></li><li><a href="r.colors.out.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.colors.out.html"><span class="name">r.colors.out</span> <span class="desc">Exports the color table associated with a raster map.</span></a></li><li><a href="r.colors.stddev.html"><img class="linkimg" src="r_colors_stddev.png"></a><a href="r.colors.stddev.html"><span class="name">r.colors.stddev</span> <span class="desc">Sets color rules based on stddev from a raster map's mean value.</span></a></li><li><a href="r.composite.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.composite.html"><span class="name">r.composite</span> <span class="desc">Combines red, green and blue raster maps into a single composite raster map.</span></a></li><li><a href="r.compress.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.compress.html"><span class="name">r.compress</span> <span class="desc">Compresses and decompresses raster maps.</span></a></li><li><a href="r.contour.html"><img class="linkimg" src="r_contour_using_levels.png"></a><a href="r.contour.html"><span class="name">r.contour</span> <span class="desc">Produces a vector map of specified contours from a raster map.</span></a></li><li><a href="r.cost.html"><img class="linkimg" src="rcost_solvedir.png"></a><a href="r.cost.html"><span class="name">r.cost</span> <span class="desc">Creates a raster map showing the cumulative cost of moving between different geographic locations on an input raster map whose cell category values represent cost.</span></a></li><li><a href="r.covar.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.covar.html"><span class="name">r.covar</span> <span class="desc">Outputs a covariance/correlation matrix for user-specified raster map layer(s).</span></a></li><li><a href="r.cross.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.cross.html"><span class="name">r.cross</span> <span class="desc">Creates a cross product of the category values from multiple raster map layers.</span></a></li><li><a href="r.describe.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.describe.html"><span class="name">r.describe</span> <span class="desc">Prints terse list of category values found in a raster map layer.</span></a></li><li><a href="r.distance.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.distance.html"><span class="name">r.distance</span> <span class="desc">Locates the closest points between objects in two raster maps.</span></a></li><li><a href="r.drain.html"><img class="linkimg" src="r_drain.png"></a><a href="r.drain.html"><span class="name">r.drain</span> <span class="desc">Traces a flow through an elevation model or cost surface on a raster map.</span></a></li><li><a href="r.external.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.external.html"><span class="name">r.external</span> <span class="desc">Links GDAL supported raster data as a pseudo GRASS raster map.</span></a></li><li><a href="r.external.out.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.external.out.html"><span class="name">r.external.out</span> <span class="desc">Redirects raster output to file utilizing GDAL library rather than storing in GRASS raster format.</span></a></li><li><a href="r.fill.dir.html"><img class="linkimg" src="r_fill_dir.png"></a><a href="r.fill.dir.html"><span class="name">r.fill.dir</span> <span class="desc">Filters and generates a depressionless elevation map and a flow direction map from a given elevation raster map.</span></a></li><li><a href="r.fill.stats.html"><img class="linkimg" src="r_fill_stats_01.png"></a><a href="r.fill.stats.html"><span class="name">r.fill.stats</span> <span class="desc">Rapidly fills 'no data' cells (NULLs) of a raster map with interpolated values (IDW).</span></a></li><li><a href="r.fillnulls.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.fillnulls.html"><span class="name">r.fillnulls</span> <span class="desc">Fills no-data areas in raster maps using spline interpolation.</span></a></li><li><a href="r.flow.html"><img class="linkimg" src="r_flow_line.png"></a><a href="r.flow.html"><span class="name">r.flow</span> <span class="desc">Constructs flowlines. Computes flowlines, flowpath lengths, and flowaccumulation (contributing areas) from a elevation raster map.</span></a></li><li><a href="r.geomorphon.html"><img class="linkimg" src="r_geomorphon.png"></a><a href="r.geomorphon.html"><span class="name">r.geomorphon</span> <span class="desc">Calculates geomorphons (terrain forms) and associated geometry using machine vision approach.</span></a></li><li><a href="r.grow.distance.html"><img class="linkimg" src="r_grow_distance.png"></a><a href="r.grow.distance.html"><span class="name">r.grow.distance</span> <span class="desc">Generates a raster map containing distances to nearest raster features and/or the value of the nearest non-null cell.</span></a></li><li><a href="r.grow.html"><img class="linkimg" src="r_grow_distance.png"></a><a href="r.grow.html"><span class="name">r.grow</span> <span class="desc">Generates a raster map layer with contiguous areas grown by one cell.</span></a></li><li><a href="r.gwflow.html"><img class="linkimg" src="r_gwflow_concept.png"></a><a href="r.gwflow.html"><span class="name">r.gwflow</span> <span class="desc">Numerical calculation program for transient, confined and unconfined groundwater flow in two dimensions.</span></a></li><li><a href="r.his.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.his.html"><span class="name">r.his</span> <span class="desc">Generates red, green and blue (RGB) raster map layers combining hue, intensity and saturation (HIS) values from user-specified input raster map layers.</span></a></li><li><a href="r.horizon.html"><img class="linkimg" src="rhorizon_polar_plot.png"></a><a href="r.horizon.html"><span class="name">r.horizon</span> <span class="desc">Computes horizon angle height from a digital elevation model. The module has two different modes of operation: 1. Computes the entire horizon around a single point whose coordinates are given with the 'coord' option. The horizon height (in radians). 2. Computes one or more raster maps of the horizon height in a single direction. The input for this is the angle (in degrees), which is measured counterclockwise with east=0, north=90 etc. The output is the horizon height in radians.</span></a></li><li><a href="r.import.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.import.html"><span class="name">r.import</span> <span class="desc">Imports raster data into a GRASS raster map using GDAL library and reprojects on the fly.</span></a></li><li><a href="r.in.ascii.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.in.ascii.html"><span class="name">r.in.ascii</span> <span class="desc">Converts a GRASS ASCII raster file to binary raster map.</span></a></li><li><a href="r.in.aster.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.in.aster.html"><span class="name">r.in.aster</span> <span class="desc">Georeference, rectify, and import Terra-ASTER imagery and relative DEMs using gdalwarp.</span></a></li><li><a href="r.in.bin.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.in.bin.html"><span class="name">r.in.bin</span> <span class="desc">Import a binary raster file into a GRASS raster map layer.</span></a></li><li><a href="r.in.gdal.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.in.gdal.html"><span class="name">r.in.gdal</span> <span class="desc">Imports raster data into a GRASS raster map using GDAL library.</span></a></li><li><a href="r.in.gridatb.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.in.gridatb.html"><span class="name">r.in.gridatb</span> <span class="desc">Imports GRIDATB.FOR map file (TOPMODEL) into a GRASS raster map.</span></a></li><li><a href="r.in.lidar.html"><img class="linkimg" src="r_in_lidar.png"></a><a href="r.in.lidar.html"><span class="name">r.in.lidar</span> <span class="desc">Creates a raster map from LAS LiDAR points using univariate statistics.</span></a></li><li><a href="r.in.mat.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.in.mat.html"><span class="name">r.in.mat</span> <span class="desc">Imports a binary MAT-File(v4) to a GRASS raster.</span></a></li><li><a href="r.in.png.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.in.png.html"><span class="name">r.in.png</span> <span class="desc">Imports non-georeferenced PNG format image.</span></a></li><li><a href="r.in.poly.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.in.poly.html"><span class="name">r.in.poly</span> <span class="desc">Creates raster maps from ASCII polygon/line/point data files.</span></a></li><li><a href="r.in.srtm.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.in.srtm.html"><span class="name">r.in.srtm</span> <span class="desc">Imports SRTM HGT files into raster map.</span></a></li><li><a href="r.in.wms.html"><img class="linkimg" src="r_in_wms_sentinel2.jpg"></a><a href="r.in.wms.html"><span class="name">r.in.wms</span> <span class="desc">Downloads and imports data from OGC WMS and OGC WMTS web mapping servers.</span></a></li><li><a href="r.in.xyz.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.in.xyz.html"><span class="name">r.in.xyz</span> <span class="desc">Creates a raster map from an assemblage of many coordinates using univariate statistics.</span></a></li><li><a href="r.info.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.info.html"><span class="name">r.info</span> <span class="desc">Outputs basic information about a raster map.</span></a></li><li><a href="r.kappa.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.kappa.html"><span class="name">r.kappa</span> <span class="desc">Calculates error matrix and kappa parameter for accuracy assessment of classification result.</span></a></li><li><a href="r.lake.html"><img class="linkimg" src="r_lake_lidar_dem.jpg"></a><a href="r.lake.html"><span class="name">r.lake</span> <span class="desc">Fills lake at given point to given level.</span></a></li><li><a href="r.latlong.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.latlong.html"><span class="name">r.latlong</span> <span class="desc">Creates a latitude/longitude raster map.</span></a></li><li><a href="r.li.cwed.html"><img class="linkimg" src="rlicwed_formula.png"></a><a href="r.li.cwed.html"><span class="name">r.li.cwed</span> <span class="desc">Calculates contrast weighted edge density index on a raster map</span></a></li><li><a href="r.li.daemon.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.li.daemon.html"><span class="name">r.li.daemon</span> <span class="desc">Support module for r.li landscape index calculations.</span></a></li><li><a href="r.li.dominance.html"><img class="linkimg" src="r_li_dominance_formula.png"></a><a href="r.li.dominance.html"><span class="name">r.li.dominance</span> <span class="desc">Calculates dominance's diversity index on a raster map</span></a></li><li><a href="r.li.edgedensity.html"><img class="linkimg" src="r_li_edgedensity_formula_1.png"></a><a href="r.li.edgedensity.html"><span class="name">r.li.edgedensity</span> <span class="desc">Calculates edge density index on a raster map, using a 4 neighbour algorithm</span></a></li><li><a href="r.li.html"><img class="linkimg" src="r_li_renyi.png"></a><a href="r.li.html"><span class="name">r.li</span> <span class="desc">Landscape structure analysis package overview</span></a></li><li><a href="r.li.mpa.html"><img class="linkimg" src="rlimpa_formula.png"></a><a href="r.li.mpa.html"><span class="name">r.li.mpa</span> <span class="desc">Calculates mean pixel attribute index on a raster map</span></a></li><li><a href="r.li.mps.html"><img class="linkimg" src="rlimps_formula.png"></a><a href="r.li.mps.html"><span class="name">r.li.mps</span> <span class="desc">Calculates mean patch size index on a raster map, using a 4 neighbour algorithm</span></a></li><li><a href="r.li.padcv.html"><img class="linkimg" src="rlipadcv_formula1.png"></a><a href="r.li.padcv.html"><span class="name">r.li.padcv</span> <span class="desc">Calculates coefficient of variation of patch area on a raster map</span></a></li><li><a href="r.li.padrange.html"><img class="linkimg" src="rlipadrange_formula.png"></a><a href="r.li.padrange.html"><span class="name">r.li.padrange</span> <span class="desc">Calculates range of patch area size on a raster map</span></a></li><li><a href="r.li.padsd.html"><img class="linkimg" src="rlipadsd_formula.png"></a><a href="r.li.padsd.html"><span class="name">r.li.padsd</span> <span class="desc">Calculates standard deviation of patch area a raster map</span></a></li><li><a href="r.li.patchdensity.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.li.patchdensity.html"><span class="name">r.li.patchdensity</span> <span class="desc">Calculates patch density index on a raster map, using a 4 neighbour algorithm</span></a></li><li><a href="r.li.patchnum.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.li.patchnum.html"><span class="name">r.li.patchnum</span> <span class="desc">Calculates patch number index on a raster map, using a 4 neighbour algorithm.</span></a></li><li><a href="r.li.pielou.html"><img class="linkimg" src="r_li_pielou.png"></a><a href="r.li.pielou.html"><span class="name">r.li.pielou</span> <span class="desc">Calculates Pielou's diversity index on a raster map</span></a></li><li><a href="r.li.renyi.html"><img class="linkimg" src="r_li_renyi.png"></a><a href="r.li.renyi.html"><span class="name">r.li.renyi</span> <span class="desc">Calculates Renyi's diversity index on a raster map</span></a></li><li><a href="r.li.richness.html"><img class="linkimg" src="r_li_richness_formula.png"></a><a href="r.li.richness.html"><span class="name">r.li.richness</span> <span class="desc">Calculates richness index on a raster map</span></a></li><li><a href="r.li.shannon.html"><img class="linkimg" src="r_li_shannon_formula.png"></a><a href="r.li.shannon.html"><span class="name">r.li.shannon</span> <span class="desc">Calculates Shannon's diversity index on a raster map</span></a></li><li><a href="r.li.shape.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.li.shape.html"><span class="name">r.li.shape</span> <span class="desc">Calculates shape index on a raster map</span></a></li><li><a href="r.li.simpson.html"><img class="linkimg" src="r_li_simpson_formula.png"></a><a href="r.li.simpson.html"><span class="name">r.li.simpson</span> <span class="desc">Calculates Simpson's diversity index on a raster map</span></a></li><li><a href="r.mapcalc.html"><img class="linkimg" src="r_mapcalc_simple.png"></a><a href="r.mapcalc.html"><span class="name">r.mapcalc</span> <span class="desc">Raster map calculator.</span></a></li><li><a href="r.mapcalc.simple.html"><img class="linkimg" src="r_mapcalc_simple.png"></a><a href="r.mapcalc.simple.html"><span class="name">r.mapcalc.simple</span> <span class="desc">Calculates a new raster map from a simple r.mapcalc expression.</span></a></li><li><a href="r.mask.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.mask.html"><span class="name">r.mask</span> <span class="desc">Creates a raster mask for limiting raster operation.</span></a></li><li><a href="r.mask.status.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.mask.status.html"><span class="name">r.mask.status</span> <span class="desc">Reports presence or absence of a raster mask Provides information about the presence of a 2D raster mask as text output or return code</span></a></li><li><a href="r.mfilter.html"><img class="linkimg" src="r_mfilter.png"></a><a href="r.mfilter.html"><span class="name">r.mfilter</span> <span class="desc">Performs raster map matrix filter.</span></a></li><li><a href="r.mode.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.mode.html"><span class="name">r.mode</span> <span class="desc">Finds the mode of values in a cover map within areas assigned the same category value in a user-specified base map.</span></a></li><li><a href="r.neighbors.html"><img class="linkimg" src="r_neighbors.png"></a><a href="r.neighbors.html"><span class="name">r.neighbors</span> <span class="desc">Makes each cell category value a function of the category values assigned to the cells around it, and stores new cell values in an output raster map layer.</span></a></li><li><a href="r.null.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.null.html"><span class="name">r.null</span> <span class="desc">Manages NULL-values of given raster map.</span></a></li><li><a href="r.object.geometry.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.object.geometry.html"><span class="name">r.object.geometry</span> <span class="desc">Calculates geometry parameters for raster objects.</span></a></li><li><a href="r.out.ascii.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.out.ascii.html"><span class="name">r.out.ascii</span> <span class="desc">Converts a raster map layer into a GRASS ASCII text file.</span></a></li><li><a href="r.out.bin.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.out.bin.html"><span class="name">r.out.bin</span> <span class="desc">Exports a GRASS raster to a binary array.</span></a></li><li><a href="r.out.gdal.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.out.gdal.html"><span class="name">r.out.gdal</span> <span class="desc">Exports GRASS raster maps into GDAL supported formats.</span></a></li><li><a href="r.out.gridatb.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.out.gridatb.html"><span class="name">r.out.gridatb</span> <span class="desc">Exports GRASS raster map to GRIDATB.FOR map file (TOPMODEL).</span></a></li><li><a href="r.out.mat.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.out.mat.html"><span class="name">r.out.mat</span> <span class="desc">Exports a GRASS raster to a binary MAT-File.</span></a></li><li><a href="r.out.mpeg.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.out.mpeg.html"><span class="name">r.out.mpeg</span> <span class="desc">Converts raster map series to MPEG movie.</span></a></li><li><a href="r.out.png.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.out.png.html"><span class="name">r.out.png</span> <span class="desc">Export a GRASS raster map as a non-georeferenced PNG image.</span></a></li><li><a href="r.out.pov.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.out.pov.html"><span class="name">r.out.pov</span> <span class="desc">Converts a raster map layer into a height-field file for POV-Ray.</span></a></li><li><a href="r.out.ppm.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.out.ppm.html"><span class="name">r.out.ppm</span> <span class="desc">Converts a GRASS raster map to a PPM image file.</span></a></li><li><a href="r.out.ppm3.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.out.ppm3.html"><span class="name">r.out.ppm3</span> <span class="desc">Converts 3 GRASS raster layers (R,G,B) to a PPM image file.</span></a></li><li><a href="r.out.vrml.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.out.vrml.html"><span class="name">r.out.vrml</span> <span class="desc">Exports a raster map to the Virtual Reality Modeling Language (VRML).</span></a></li><li><a href="r.out.vtk.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.out.vtk.html"><span class="name">r.out.vtk</span> <span class="desc">Converts raster maps into the VTK-ASCII format.</span></a></li><li><a href="r.out.xyz.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.out.xyz.html"><span class="name">r.out.xyz</span> <span class="desc">Exports a raster map to a text file as x,y,z values based on cell centers.</span></a></li><li><a href="r.pack.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.pack.html"><span class="name">r.pack</span> <span class="desc">Exports a raster map as GRASS specific archive file</span></a></li><li><a href="r.param.scale.html"><img class="linkimg" src="r_param_scale_morph.jpg"></a><a href="r.param.scale.html"><span class="name">r.param.scale</span> <span class="desc">Extracts terrain parameters from a DEM. Uses a multi-scale approach by taking fitting quadratic parameters to any size window (via least squares).</span></a></li><li><a href="r.patch.html"><img class="linkimg" src="r_patch.png"></a><a href="r.patch.html"><span class="name">r.patch</span> <span class="desc">Creates a composite raster map layer by using known category values from one (or more) map layer(s) to fill in areas of "no data" in another map layer.</span></a></li><li><a href="r.path.html"><img class="linkimg" src="r_path.png"></a><a href="r.path.html"><span class="name">r.path</span> <span class="desc">Traces paths from starting points following input directions.</span></a></li><li><a href="r.plane.html"><img class="linkimg" src="r_plane_3d.png"></a><a href="r.plane.html"><span class="name">r.plane</span> <span class="desc">Creates raster plane map given dip (inclination), aspect (azimuth) and one point.</span></a></li><li><a href="r.profile.html"><img class="linkimg" src="rprofile_plot.png"></a><a href="r.profile.html"><span class="name">r.profile</span> <span class="desc">Outputs the raster map layer values lying on user-defined line(s).</span></a></li><li><a href="r.proj.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.proj.html"><span class="name">r.proj</span> <span class="desc">Re-projects a raster map from given project to the current project.</span></a></li><li><a href="r.quant.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.quant.html"><span class="name">r.quant</span> <span class="desc">Produces the quantization file for a floating-point map.</span></a></li><li><a href="r.quantile.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.quantile.html"><span class="name">r.quantile</span> <span class="desc">Compute quantiles using two passes.</span></a></li><li><a href="r.random.cells.html"><img class="linkimg" src="r_random_cells.png"></a><a href="r.random.cells.html"><span class="name">r.random.cells</span> <span class="desc">Generates random cell values with spatial dependence.</span></a></li><li><a href="r.random.html"><img class="linkimg" src="r_random_cells.png"></a><a href="r.random.html"><span class="name">r.random</span> <span class="desc">Creates randomly placed raster cells or vector points Creates a raster map and vector point map containing randomly located cells and points.</span></a></li><li><a href="r.random.surface.html"><img class="linkimg" src="r_random_surface.jpg"></a><a href="r.random.surface.html"><span class="name">r.random.surface</span> <span class="desc">Generates random surface(s) with spatial dependence.</span></a></li><li><a href="r.reclass.area.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.reclass.area.html"><span class="name">r.reclass.area</span> <span class="desc">Reclasses a raster map greater or less than user specified area size (in hectares).</span></a></li><li><a href="r.reclass.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.reclass.html"><span class="name">r.reclass</span> <span class="desc">Reclassify raster map based on category values. Creates a new raster map whose category values are based upon a reclassification of the categories in an existing raster map.</span></a></li><li><a href="r.recode.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.recode.html"><span class="name">r.recode</span> <span class="desc">Recodes categorical raster maps.</span></a></li><li><a href="r.region.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.region.html"><span class="name">r.region</span> <span class="desc">Sets the boundary definitions for a raster map.</span></a></li><li><a href="r.regression.line.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.regression.line.html"><span class="name">r.regression.line</span> <span class="desc">Calculates linear regression from two raster maps: y = a + b*x.</span></a></li><li><a href="r.regression.multi.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.regression.multi.html"><span class="name">r.regression.multi</span> <span class="desc">Calculates multiple linear regression from raster maps.</span></a></li><li><a href="r.relief.html"><img class="linkimg" src="r_relief.png"></a><a href="r.relief.html"><span class="name">r.relief</span> <span class="desc">Creates shaded relief map from an elevation map (DEM).</span></a></li><li><a href="r.report.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.report.html"><span class="name">r.report</span> <span class="desc">Reports statistics for raster maps.</span></a></li><li><a href="r.resamp.bspline.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.resamp.bspline.html"><span class="name">r.resamp.bspline</span> <span class="desc">Performs bilinear or bicubic spline interpolation with Tykhonov regularization.</span></a></li><li><a href="r.resamp.filter.html"><img class="linkimg" src="r_resamp_filter_benchmark_size.png"></a><a href="r.resamp.filter.html"><span class="name">r.resamp.filter</span> <span class="desc">Resamples raster map layers using an analytic kernel.</span></a></li><li><a href="r.resamp.interp.html"><img class="linkimg" src="r_resamp_interp_new_250m.png"></a><a href="r.resamp.interp.html"><span class="name">r.resamp.interp</span> <span class="desc">Resamples raster map to a finer grid using interpolation.</span></a></li><li><a href="r.resamp.rst.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.resamp.rst.html"><span class="name">r.resamp.rst</span> <span class="desc">Reinterpolates and optionally computes topographic analysis from input raster map to a new raster map (possibly with different resolution) using regularized spline with tension and smoothing.</span></a></li><li><a href="r.resamp.stats.html"><img class="linkimg" src="r_resamp_stats_6m_20m.png"></a><a href="r.resamp.stats.html"><span class="name">r.resamp.stats</span> <span class="desc">Resamples raster map layers to a coarser grid using aggregation.</span></a></li><li><a href="r.resample.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.resample.html"><span class="name">r.resample</span> <span class="desc">GRASS raster map layer data resampling capability.</span></a></li><li><a href="r.rescale.eq.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.rescale.eq.html"><span class="name">r.rescale.eq</span> <span class="desc">Rescales histogram equalized the range of category values in a raster map layer.</span></a></li><li><a href="r.rescale.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.rescale.html"><span class="name">r.rescale</span> <span class="desc">Rescales the range of category values in a raster map layer.</span></a></li><li><a href="r.rgb.html"><img class="linkimg" src="r_rgb_elevation.png"></a><a href="r.rgb.html"><span class="name">r.rgb</span> <span class="desc">Splits a raster map into red, green and blue maps.</span></a></li><li><a href="r.ros.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.ros.html"><span class="name">r.ros</span> <span class="desc">Generates rate of spread raster maps. Generates three, or four raster map layers showing the base (perpendicular) rate of spread (ROS), the maximum (forward) ROS, the direction of the maximum ROS, and optionally the maximum potential spotting distance for fire spread simulation.</span></a></li><li><a href="r.semantic.label.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.semantic.label.html"><span class="name">r.semantic.label</span> <span class="desc">Manages semantic label information assigned to a single raster map or to a list of raster maps.</span></a></li><li><a href="r.series.accumulate.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.series.accumulate.html"><span class="name">r.series.accumulate</span> <span class="desc">Makes each output cell value a accumulationfunction of the values assigned to the corresponding cells in the input raster map layers.</span></a></li><li><a href="r.series.interp.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.series.interp.html"><span class="name">r.series.interp</span> <span class="desc">Interpolates raster maps located (temporal or spatial) in between input raster maps at specific sampling positions.</span></a></li><li><a href="r.series.html"><img class="linkimg" src="r_series.png"></a><a href="r.series.html"><span class="name">r.series</span> <span class="desc">Makes each output cell value a function of the values assigned to the corresponding cells in the input raster map layers.</span></a></li><li><a href="r.shade.html"><img class="linkimg" src="rshade.png"></a><a href="r.shade.html"><span class="name">r.shade</span> <span class="desc">Drapes a color raster over an shaded relief or aspect map.</span></a></li><li><a href="r.sim.sediment.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.sim.sediment.html"><span class="name">r.sim.sediment</span> <span class="desc">Sediment transport and erosion/deposition simulation using path sampling method (SIMWE).</span></a></li><li><a href="r.sim.water.html"><img class="linkimg" src="r_sim_water.png"></a><a href="r.sim.water.html"><span class="name">r.sim.water</span> <span class="desc">Overland flow hydrologic simulation using path sampling method (SIMWE).</span></a></li><li><a href="r.slope.aspect.html"><img class="linkimg" src="r_slope_aspect_pcurv.png"></a><a href="r.slope.aspect.html"><span class="name">r.slope.aspect</span> <span class="desc">Generates raster maps of slope, aspect, curvatures and partial derivatives from an elevation raster map. Aspect is calculated counterclockwise from east.</span></a></li><li><a href="r.smooth.edgepreserve.html"><img class="linkimg" src="r_smooth_edgepreserve.jpg"></a><a href="r.smooth.edgepreserve.html"><span class="name">r.smooth.edgepreserve</span> <span class="desc">Smoothing with anisotropic diffusion</span></a></li><li><a href="r.solute.transport.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.solute.transport.html"><span class="name">r.solute.transport</span> <span class="desc">Numerical calculation program for transient, confined and unconfined solute transport in two dimensions</span></a></li><li><a href="r.spread.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.spread.html"><span class="name">r.spread</span> <span class="desc">Simulates elliptically anisotropic spread. Generates a raster map of the cumulative time of spread, given raster maps containing the rates of spread (ROS), the ROS directions and the spread origins. It optionally produces raster maps to contain backlink UTM coordinates for tracing spread paths. Usable for fire spread simulations.</span></a></li><li><a href="r.spreadpath.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.spreadpath.html"><span class="name">r.spreadpath</span> <span class="desc">Recursively traces the least cost path backwards to cells from which the cumulative cost was determined.</span></a></li><li><a href="r.statistics.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.statistics.html"><span class="name">r.statistics</span> <span class="desc">Calculates category or object oriented statistics.</span></a></li><li><a href="r.stats.html"><img class="linkimg" src="r_stats.zonal.png"></a><a href="r.stats.html"><span class="name">r.stats</span> <span class="desc">Generates area statistics for raster map.</span></a></li><li><a href="r.stats.quantile.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.stats.quantile.html"><span class="name">r.stats.quantile</span> <span class="desc">Compute category quantiles using two passes.</span></a></li><li><a href="r.stats.zonal.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.stats.zonal.html"><span class="name">r.stats.zonal</span> <span class="desc">Calculates category or object oriented statistics (accumulator-based statistics).</span></a></li><li><a href="r.stream.extract.html"><img class="linkimg" src="r_stream_extract_weights_zoom.png"></a><a href="r.stream.extract.html"><span class="name">r.stream.extract</span> <span class="desc">Performs stream network extraction.</span></a></li><li><a href="r.sun.html"><img class="linkimg" src="r_sunhours.png"></a><a href="r.sun.html"><span class="name">r.sun</span> <span class="desc">Solar irradiance and irradiation model. Computes direct (beam), diffuse and reflected solar irradiation raster maps for given day, latitude, surface and atmospheric conditions. Solar parameters (e.g. sunrise, sunset times, declination, extraterrestrial irradiance, daylight length) are saved in the map history file. Alternatively, a local time can be specified to compute solar incidence angle and/or irradiance raster maps. The shadowing effect of the topography is optionally incorporated.</span></a></li><li><a href="r.sunhours.html"><img class="linkimg" src="r_sunhours.png"></a><a href="r.sunhours.html"><span class="name">r.sunhours</span> <span class="desc">Calculates solar elevation, solar azimuth, and sun hours. Solar elevation: the angle between the direction of the geometric center of the sun's apparent disk and the (idealized) horizon. Solar azimuth: the angle from due north in clockwise direction.</span></a></li><li><a href="r.sunmask.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.sunmask.html"><span class="name">r.sunmask</span> <span class="desc">Calculates cast shadow areas from sun position and elevation raster map. Either exact sun position (A) is specified, or date/time to calculate the sun position (B) by r.sunmask itself.</span></a></li><li><a href="r.support.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.support.html"><span class="name">r.support</span> <span class="desc">Allows creation and/or modification of raster map layer support files.</span></a></li><li><a href="r.support.stats.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.support.stats.html"><span class="name">r.support.stats</span> <span class="desc">Update raster map statistics</span></a></li><li><a href="r.surf.area.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.surf.area.html"><span class="name">r.surf.area</span> <span class="desc">Prints estimation of surface area for raster map.</span></a></li><li><a href="r.surf.contour.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.surf.contour.html"><span class="name">r.surf.contour</span> <span class="desc">Generates surface raster map from rasterized contours.</span></a></li><li><a href="r.surf.fractal.html"><img class="linkimg" src="r_surf_fractal.jpg"></a><a href="r.surf.fractal.html"><span class="name">r.surf.fractal</span> <span class="desc">Creates a fractal surface of a given fractal dimension.</span></a></li><li><a href="r.surf.gauss.html"><img class="linkimg" src="r_surf_gauss.jpg"></a><a href="r.surf.gauss.html"><span class="name">r.surf.gauss</span> <span class="desc">Generates a raster map using gaussian random number generator. Mean and standard deviation of gaussian deviates can be expressed by the user.</span></a></li><li><a href="r.surf.idw.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.surf.idw.html"><span class="name">r.surf.idw</span> <span class="desc">Provides surface interpolation from raster point data by Inverse Distance Squared Weighting.</span></a></li><li><a href="r.surf.random.html"><img class="linkimg" src="r_surf_random.jpg"></a><a href="r.surf.random.html"><span class="name">r.surf.random</span> <span class="desc">Produces a raster surface map of uniform random deviates with defined range.</span></a></li><li><a href="r.terraflow.html"><img class="linkimg" src="rterraflow_dir2.png"></a><a href="r.terraflow.html"><span class="name">r.terraflow</span> <span class="desc">Performs flow computation for massive grids.</span></a></li><li><a href="r.texture.html"><img class="linkimg" src="r_texture_window_time.png"></a><a href="r.texture.html"><span class="name">r.texture</span> <span class="desc">Generate images with textural features from a raster map.</span></a></li><li><a href="r.thin.html"><img class="linkimg" src="r_thin_network.png"></a><a href="r.thin.html"><span class="name">r.thin</span> <span class="desc">Thins non-null cells that denote linear features in a raster map layer.</span></a></li><li><a href="r.tile.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.tile.html"><span class="name">r.tile</span> <span class="desc">Splits a raster map into tiles.</span></a></li><li><a href="r.tileset.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.tileset.html"><span class="name">r.tileset</span> <span class="desc">Produces tilings of the source projection for use in the destination region and projection.</span></a></li><li><a href="r.timestamp.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.timestamp.html"><span class="name">r.timestamp</span> <span class="desc">Modifies a timestamp for a raster map. Print/add/remove a timestamp for a raster map.</span></a></li><li><a href="r.to.rast3.html"><img class="linkimg" src="r.to.rast3.png"></a><a href="r.to.rast3.html"><span class="name">r.to.rast3</span> <span class="desc">Converts 2D raster map slices to one 3D raster volume map.</span></a></li><li><a href="r.to.rast3elev.html"><img class="linkimg" src="r.to.rast3elev.png"></a><a href="r.to.rast3elev.html"><span class="name">r.to.rast3elev</span> <span class="desc">Creates a 3D volume map based on 2D elevation and value raster maps.</span></a></li><li><a href="r.to.vect.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.to.vect.html"><span class="name">r.to.vect</span> <span class="desc">Converts a raster map into a vector map.</span></a></li><li><a href="r.topidx.html"><img class="linkimg" src="r_topidx.png"></a><a href="r.topidx.html"><span class="name">r.topidx</span> <span class="desc">Creates a topographic index (wetness index) raster map from an elevation raster map.</span></a></li><li><a href="r.topmodel.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.topmodel.html"><span class="name">r.topmodel</span> <span class="desc">Simulates TOPMODEL which is a physically based hydrologic model.</span></a></li><li><a href="r.transect.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.transect.html"><span class="name">r.transect</span> <span class="desc">Outputs raster map layer values lying along user defined transect line(s).</span></a></li><li><a href="r.univar.html"><img class="linkimg" src="runivar_basins.png"></a><a href="r.univar.html"><span class="name">r.univar</span> <span class="desc">Calculates univariate statistics from the non-null cells of a raster map. Statistics include number of cells counted, minimum and maximum cell values, range, arithmetic mean, population variance, standard deviation, coefficient of variation, and sum.</span></a></li><li><a href="r.unpack.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.unpack.html"><span class="name">r.unpack</span> <span class="desc">Imports a GRASS specific raster archive file (packed with r.pack) as a raster map</span></a></li><li><a href="r.uslek.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.uslek.html"><span class="name">r.uslek</span> <span class="desc">Computes USLE Soil Erodibility Factor (K).</span></a></li><li><a href="r.usler.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.usler.html"><span class="name">r.usler</span> <span class="desc">Computes USLE R factor, Rainfall erosivity index.</span></a></li><li><a href="r.viewshed.html"><img class="linkimg" src="r.viewshed.png"></a><a href="r.viewshed.html"><span class="name">r.viewshed</span> <span class="desc">Computes the viewshed of a point on an elevation raster map. Default format: NULL (invisible), vertical angle wrt viewpoint (visible).</span></a></li><li><a href="r.volume.html"><img class="linkimg" src="r_volume_lake.png"></a><a href="r.volume.html"><span class="name">r.volume</span> <span class="desc">Calculates the volume of data "clumps". Optionally produces a GRASS vector points map containing the calculated centroids of these clumps.</span></a></li><li><a href="r.walk.html"><img class="linkimg" src="r_walk.png"></a><a href="r.walk.html"><span class="name">r.walk</span> <span class="desc">Creates a raster map showing the anisotropic cumulative cost of moving between different geographic locations on an input raster map whose cell category values represent cost.</span></a></li><li><a href="r.water.outlet.html"><img class="linkimg" src="r_water_outlet.png"></a><a href="r.water.outlet.html"><span class="name">r.water.outlet</span> <span class="desc">Creates watershed basins from a drainage direction map.</span></a></li><li><a href="r.watershed.html"><img class="linkimg" src="r_watershed_drainage.png"></a><a href="r.watershed.html"><span class="name">r.watershed</span> <span class="desc">Calculates hydrological parameters and RUSLE factors.</span></a></li><li><a href="r.what.color.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.what.color.html"><span class="name">r.what.color</span> <span class="desc">Queries colors for a raster map layer.</span></a></li><li><a href="r.what.html"><img class="default-img" src="grass_logo.svg"></a><a href="r.what.html"><span class="name">r.what</span> <span class="desc">Queries raster maps on their category values and category labels.</span></a></li></ul>