<style>
.img-list {
    margin: 0;
    padding: 0;
    list-style-type: none;
}

.img-list li {
    padding: 5px;
    overflow: auto;
}

.img-list li:hover {
    background-color: #eee;
}

.img-list li a {
    color: initial;
    text-decoration: none;
    display: block;
}

.img-list li img {
    width: 10%;
    float: left;
    margin: 0 15px 0 0;
    background: white;
    object-fit: scale-down;
}

.img-list li img.default-img {
    max-height: 5ex;
    background-color: var(--gs-primary-color);
    padding: 5px;
}

.img-list li .desc {
    margin: 0px;
}

.img-list li .name {
    margin: 5px;
    display: block;
    color: #409940;
    font-weight: bold;
    font-style: italic;
}
</style>
Go to <a href="3d rasterintro.html">3D raster introduction</a> | <a href="topics.html">topics</a> <p>
# 3D raster tools
<ul class="img-list"><li><a href="r3.colors.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.colors.html"><span class="name">r3.colors</span> <span class="desc">Creates/modifies the color table associated with a 3D raster map.</span></a></li><li><a href="r3.colors.out.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.colors.out.html"><span class="name">r3.colors.out</span> <span class="desc">Exports the color table associated with a 3D raster map.</span></a></li><li><a href="r3.cross.rast.html"><img class="linkimg" src="r3.cross.rast.png"></a><a href="r3.cross.rast.html"><span class="name">r3.cross.rast</span> <span class="desc">Creates cross section 2D raster map from 3D raster map based on 2D elevation map</span></a></li><li><a href="r3.flow.html"><img class="linkimg" src="r3flow_flowlines.png"></a><a href="r3.flow.html"><span class="name">r3.flow</span> <span class="desc">Computes 3D flow lines and 3D flow accumulation.</span></a></li><li><a href="r3.gradient.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.gradient.html"><span class="name">r3.gradient</span> <span class="desc">Computes gradient of a 3D raster map and outputs gradient components as three 3D raster maps.</span></a></li><li><a href="r3.gwflow.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.gwflow.html"><span class="name">r3.gwflow</span> <span class="desc">Numerical calculation program for transient, confined groundwater flow in three dimensions.</span></a></li><li><a href="r3.in.ascii.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.in.ascii.html"><span class="name">r3.in.ascii</span> <span class="desc">Converts a 3D ASCII raster text file into a (binary) 3D raster map.</span></a></li><li><a href="r3.in.bin.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.in.bin.html"><span class="name">r3.in.bin</span> <span class="desc">Imports a binary raster file into a GRASS 3D raster map.</span></a></li><li><a href="r3.in.lidar.html"><img class="linkimg" src="r3_in_lidar.png"></a><a href="r3.in.lidar.html"><span class="name">r3.in.lidar</span> <span class="desc">Creates a 3D raster map from LAS LiDAR points using univariate statistics.</span></a></li><li><a href="r3.in.v5d.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.in.v5d.html"><span class="name">r3.in.v5d</span> <span class="desc">Import 3-dimensional Vis5D files.</span></a></li><li><a href="r3.in.xyz.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.in.xyz.html"><span class="name">r3.in.xyz</span> <span class="desc">Create a 3D raster map from an assemblage of many coordinates using univariate statistics</span></a></li><li><a href="r3.info.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.info.html"><span class="name">r3.info</span> <span class="desc">Outputs basic information about a user-specified 3D raster map layer.</span></a></li><li><a href="r3.mapcalc.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.mapcalc.html"><span class="name">r3.mapcalc</span> <span class="desc">Raster map calculator.</span></a></li><li><a href="r3.mask.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.mask.html"><span class="name">r3.mask</span> <span class="desc">Establishes the current working 3D raster mask.</span></a></li><li><a href="r3.mkdspf.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.mkdspf.html"><span class="name">r3.mkdspf</span> <span class="desc">Creates a display file from an existing 3D raster map according to specified threshold levels.</span></a></li><li><a href="r3.neighbors.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.neighbors.html"><span class="name">r3.neighbors</span> <span class="desc">Makes each voxel value a function of the values assigned to the voxels around it, and stores new voxel values in an output 3D raster map</span></a></li><li><a href="r3.null.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.null.html"><span class="name">r3.null</span> <span class="desc">Explicitly create the 3D NULL-value bitmap file.</span></a></li><li><a href="r3.out.ascii.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.out.ascii.html"><span class="name">r3.out.ascii</span> <span class="desc">Converts a 3D raster map layer into a ASCII text file.</span></a></li><li><a href="r3.out.bin.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.out.bin.html"><span class="name">r3.out.bin</span> <span class="desc">Exports a GRASS 3D raster map to a binary array.</span></a></li><li><a href="r3.out.netcdf.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.out.netcdf.html"><span class="name">r3.out.netcdf</span> <span class="desc">Export a 3D raster map as netCDF file.</span></a></li><li><a href="r3.out.v5d.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.out.v5d.html"><span class="name">r3.out.v5d</span> <span class="desc">Exports GRASS 3D raster map to 3-dimensional Vis5D file.</span></a></li><li><a href="r3.out.vtk.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.out.vtk.html"><span class="name">r3.out.vtk</span> <span class="desc">Converts 3D raster maps into the VTK-ASCII format.</span></a></li><li><a href="r3.retile.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.retile.html"><span class="name">r3.retile</span> <span class="desc">Retiles an existing 3D raster map with user defined x, y and z tile size.</span></a></li><li><a href="r3.stats.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.stats.html"><span class="name">r3.stats</span> <span class="desc">Generates volume statistics for 3D raster maps.</span></a></li><li><a href="r3.support.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.support.html"><span class="name">r3.support</span> <span class="desc">Allows creation and/or modification of 3D raster map layer support files.</span></a></li><li><a href="r3.timestamp.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.timestamp.html"><span class="name">r3.timestamp</span> <span class="desc">Modifies a timestamp for a 3D raster map. Print/add/remove a timestamp for a 3D raster map.</span></a></li><li><a href="r3.to.rast.html"><img class="linkimg" src="r3.to.rast.png"></a><a href="r3.to.rast.html"><span class="name">r3.to.rast</span> <span class="desc">Converts 3D raster maps to 2D raster maps</span></a></li><li><a href="r3.univar.html"><img class="default-img" src="grass_logo.svg"></a><a href="r3.univar.html"><span class="name">r3.univar</span> <span class="desc">Calculates univariate statistics from the non-null cells of a 3D raster map. Statistics include number of cells counted, minimum and maximum cell values, range, arithmetic mean, population variance, standard deviation, coefficient of variation, and sum.</span></a></li></ul>