---
name: r.usler
description: Computes USLE R factor, Rainfall erosivity index.
keywords: [ raster, hydrology, rainfall, soil, erosion ]
---

# r.usler

Computes USLE R factor, Rainfall erosivity index.

=== "Command line"

    **r.usler**
    **input**=*name*
    **output**=*name*
    **method**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.usler input=name output=name method=morgan
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.usler***",
        **input**,
        **output**,
        **method**=*"morgan"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.usler", input="name", output="name", method="morgan")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_usler*(**input**,
        **output**,
        **method**=*"morgan"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_usler(input="name", output="name", method="morgan")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of annual precipitation raster map [mm/year]  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output USLE R raster map [MJ.mm/ha.hr.year]  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of USLE R equation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *roose,  morgan,  foster,  elswaify*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *morgan*  
    &nbsp;&nbsp;&nbsp;&nbsp;**roose**: Roosle (1975)  
    &nbsp;&nbsp;&nbsp;&nbsp;**morgan**: Morgan (1974)  
    &nbsp;&nbsp;&nbsp;&nbsp;**foster**: Foster (1981)  
    &nbsp;&nbsp;&nbsp;&nbsp;**elswaify**: El-Swaify (1985)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of annual precipitation raster map [mm/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output USLE R raster map [MJ.mm/ha.hr.year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of USLE R equation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *roose,  morgan,  foster,  elswaify*  
    &nbsp;&nbsp;&nbsp;&nbsp;**roose**: Roosle (1975)  
    &nbsp;&nbsp;&nbsp;&nbsp;**morgan**: Morgan (1974)  
    &nbsp;&nbsp;&nbsp;&nbsp;**foster**: Foster (1981)  
    &nbsp;&nbsp;&nbsp;&nbsp;**elswaify**: El-Swaify (1985)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *morgan*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of annual precipitation raster map [mm/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output USLE R raster map [MJ.mm/ha.hr.year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of USLE R equation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *roose,  morgan,  foster,  elswaify*  
    &nbsp;&nbsp;&nbsp;&nbsp;**roose**: Roosle (1975)  
    &nbsp;&nbsp;&nbsp;&nbsp;**morgan**: Morgan (1974)  
    &nbsp;&nbsp;&nbsp;&nbsp;**foster**: Foster (1981)  
    &nbsp;&nbsp;&nbsp;&nbsp;**elswaify**: El-Swaify (1985)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *morgan*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.usler* calculates USLE R factor for Rainfall erosivity. It enables
several empirical equations: Roosle (1975), Morgan (1974), Foster(1981)
and El-Swaify (1985).

## NOTES

*r.watershed* provides for USLE L, S, LS factors.

## EXAMPLE

TBD.

## SEE ALSO

*[r.uslek](r.uslek.md), [r.watershed](r.watershed.md)*

## AUTHORS

Natialia Medvedeva, SIC-ISDC, Ashgabat, Turkmenistan  
Yann Chemin, SIC-ISDC, Ashgabat, Turkmenistan

## SOURCE CODE

Available at: [r.usler source code](https://github.com/OSGeo/grass/tree/main/raster/r.usler)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.usler))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
