---
name: r.stats.quantile
description: Compute category quantiles using two passes.
keywords: [ raster, statistics, zonal statistics, percentile, quantile ]
---

# r.stats.quantile

Compute category quantiles using two passes.

=== "Command line"

    **r.stats.quantile**
    [**-rpt**]
    **base**=*name*
    **cover**=*name*
    [**quantiles**=*integer*]
    [**percentiles**=*float* [,*float*,...]]
    [**bins**=*integer*]
    [**output**=*name* [,*name*,...]]
    [**file**=*name*]
    [**separator**=*character*]
    **format**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.stats.quantile base=name cover=name format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r.stats.quantile***",
        **base**,
        **cover**,
        **quantiles**=*None*,
        **percentiles**=*50*,
        **bins**=*1000*,
        **output**=*None*,
        **file**=*None*,
        **separator**=*None*,
        **format**=*"plain"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r.stats.quantile", base="name", cover="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_stats_quantile*(**base**,
        **cover**,
        **quantiles**=*None*,
        **percentiles**=*50*,
        **bins**=*1000*,
        **output**=*None*,
        **file**=*None*,
        **separator**=*None*,
        **format**=*"plain"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_stats_quantile(base="name", cover="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **base**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of base raster map  
    **cover**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of cover raster map  
    **quantiles**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of quantiles  
    **percentiles**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;List of percentiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **bins**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bins to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **output**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Resultant raster map(s)  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create reclass map with statistics as category labels  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not create output maps; just print statistics  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print statistics in table format [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=csv instead.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **base** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of base raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cover** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of cover raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **quantiles** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of quantiles  
    **percentiles** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of percentiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **bins** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bins to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **output** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resultant raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *p*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create reclass map with statistics as category labels  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create output maps; just print statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print statistics in table format [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=csv instead.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **base** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of base raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cover** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of cover raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **quantiles** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of quantiles  
    **percentiles** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of percentiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **bins** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bins to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **output** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resultant raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *p*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create reclass map with statistics as category labels  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create output maps; just print statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print statistics in table format [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=csv instead.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.stats.quantile* is a tool to analyse exploratory statistics of a
floating-point "cover layer" according to how it intersects with objects
in a "base layer". It provides quantile calculations as selected "zonal
statistics".

## NOTES

*r.stats.quantile* is intended to be a partial replacement for
*[r.statistics](r.statistics.md)*, with support for floating-point cover
maps. It provides quantile calculations, which are absent from
*[r.stats.zonal](r.stats.zonal.md)*.

Quantiles are calculated following algorithm 7 from Hyndman and Fan
(1996), which is also the default in R and numpy.

The **t** flag has been deprecated and replaced by the **format=csv**
option.

The default separator will be **:** to maintain backward compatibility;
however, if **format=csv** is given, then the default separator will be **comma**.

## EXAMPLE

In this example, the raster polygon map `zipcodes` in the North Carolina
sample dataset is used to calculate quantile raster statistics using the
`elevation` raster map:

```sh
g.region raster=zipcodes -p

# print quantiles
r.stats.quantile base=zipcodes cover=elevation quantiles=3 -p
27511:0:33.333333:134.717392
27511:1:66.666667:143.985723
27513:0:33.333333:140.669993
27513:1:66.666667:146.279449
27518:0:33.333333:115.140101
27518:1:66.666667:129.893723
[...]

# write out percentile raster maps
r.stats.quantile base=zipcodes cover=elevation percentiles=25,50,75 \
  output=zipcodes_elev_q25,zipcodes_elev_q50,zipcodes_elev_q75
```

Using the JSON format option and Python to parse the
output:

```python
import grass.script as gs

data = gs.parse_command(
    "r.stats.quantile", base="zipcodes", cover="elevation", flags="p", format="json"
)
print(data[0])
```

Possible output:

```text
{'category': 27511, 'percentiles': [{'percentile': 50, 'value': 139.62598419189453}]}
```

The whole JSON may look like this:

```json
[
 {
  "category": 27511,
  "percentiles": [
   {
    "percentile": 50,
    "value": 139.62598419189453
   }
  ]
 },
 {
  "category": 27513,
  "percentiles": [
   {
    "percentile": 50,
    "value": 143.7049102783203
   }
  ]
 },
 {
  "category": 27518,
  "percentiles": [
   {
    "percentile": 50,
    "value": 122.53437805175781
   }
  ]
 }
]
```

## REFERENCES

- Hyndman and Fan (1996) *Sample Quantiles in Statistical Packages*,
  **American Statistician**. American Statistical Association. 50 (4):
  361-365. DOI:
  [10.2307/2684934](https://doi.org/10.2307/2684934%3E10.2307/2684934)
- [*Engineering Statistics Handbook:
  Percentile*](https://www.itl.nist.gov/div898/handbook/prc/section2/prc262.htm),
  NIST

## SEE ALSO

*[r.quantile](r.quantile.md), [r.stats.zonal](r.stats.zonal.md),
[r.statistics](r.statistics.md)*

## AUTHORS

Glynn Clements  
Markus Metz

## SOURCE CODE

Available at: [r.stats.quantile source code](https://github.com/OSGeo/grass/tree/main/raster/r.stats.quantile)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.stats.quantile))  
Latest change: Saturday Oct 11 04:38:40 2025 in commit [3dd71f5](https://github.com/OSGeo/grass/commit/3dd71f5fab83b72a2db2da959fe075c5b3b52200)
