---
name: r.object.geometry
description: Calculates geometry parameters for raster objects.
keywords: [ raster, statistics, reclass, clumps ]
---

# r.object.geometry

Calculates geometry parameters for raster objects.

=== "Command line"

    **r.object.geometry**
    [**-m**]
    **input**=*name*
    [**output**=*name*]
    [**separator**=*character*]
    **format**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.object.geometry input=name format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r.object.geometry***",
        **input**,
        **output**=*None*,
        **separator**=*"pipe"*,
        **format**=*"plain"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r.object.geometry", input="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_object_geometry*(**input**,
        **output**=*None*,
        **separator**=*"pipe"*,
        **format**=*"plain"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_object_geometry(input="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use meters as units instead of cells  
  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use meters as units instead of cells  
  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use meters as units instead of cells  
  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.object.geometry* calculates form statistics of raster objects in the
**input** map and writes it to the **output** text file (or standard
output if no output filename or '-' is given), with fields separated by
the chosen **separator**. Objects are defined as clumps of adjacent
cells with the same category value (e.g. output of
*[r.clump](r.clump.md)* or *[i.segment](i.segment.md)*).

By default, values are in pixels. If values in meters is desired, the
user can set the **-m** flag. If the current working region is in
lat-long or has non-square pixels, using meters is recommended.

Statistics currently calculated are exactly the same as in
*[v.to.db](v.to.db.md)* (except for compact_square and mean
coordinates):

- area
- perimeter
- compact_square (compactness compared to a square:
  `compact_square = 4 * sqrt(area) / perimeter`)
- compact_circle (compactness compared to a circle:
  `compact_circle = perimeter / ( 2 * sqrt(PI * area) )`)
- fractal dimension ( `fd = 2 * ( log(perimeter) / log(area + 0.001) )`
  )
- mean x coordinate of object (in map units)
- mean y coordinate of object (in map units)

## EXAMPLE

```sh
g.region raster=soilsID
r.object.geometry input=soilsID output=soils_geom.txt
```

The **format=json** option can be used to change the output format to
JSON:

```sh
r.object.geometry input=zipcodes format=json
```

```json
[
    {
        "category": 1,
        "area": 106,
        "perimeter": 62,
        "compact_circle": 1.6987670351864215,
        "compact_square": 0.66423420264432265,
        "fd": 1.7699924681225903,
        "mean_x": 631382.07547169807,
        "mean_y": 222764.15094339623
    },
    {
        "category": 2,
        "area": 57,
        "perimeter": 36,
        "compact_circle": 1.3451172460704992,
        "compact_square": 0.83887049280786108,
        "fd": 1.772672742164326,
        "mean_x": 643460.52631578944,
        "mean_y": 217232.45614035087
    },
    {
        "category": 3,
        "area": 10,
        "perimeter": 16,
        "compact_circle": 1.4272992929222168,
        "compact_square": 0.79056941504209488,
        "fd": 2.4081353865496951,
        "mean_x": 631300,
        "mean_y": 215450
    },
    {
        "category": 4,
        "area": 63,
        "perimeter": 60,
        "compact_circle": 2.1324361862292305,
        "compact_square": 0.52915026221291817,
        "fd": 1.9764401337147652,
        "mean_x": 642345.23809523811,
        "mean_y": 226599.20634920636
    },
    {
        "category": 5,
        "area": 491,
        "perimeter": 156,
        "compact_circle": 1.9859985189304281,
        "compact_square": 0.56816717451693177,
        "fd": 1.6299200778082998,
        "mean_x": 637912.93279022397,
        "mean_y": 220636.96537678209
    },
    {
        "category": 6,
        "area": 83,
        "perimeter": 60,
        "compact_circle": 1.8578355639603314,
        "compact_square": 0.60736223860961991,
        "fd": 1.8531256328449071,
        "mean_x": 635846.38554216863,
        "mean_y": 227219.8795180723
    }
]
```

## SEE ALSO

*[i.segment](i.segment.md), [r.clump](r.clump.md),
[v.to.db](v.to.db.md)*

## AUTHORS

Moritz Lennert  
Markus Metz (diagonal clump tracing)

## SOURCE CODE

Available at: [r.object.geometry source code](https://github.com/OSGeo/grass/tree/main/raster/r.object.geometry)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.object.geometry))  
Latest change: Thursday Nov 06 22:27:54 2025 in commit [298b386](https://github.com/OSGeo/grass/commit/298b38614712934179355ea767403d6bfea8f5f9)
