---
name: m.transform
description: Computes a coordinate transformation based on the control points.
keywords: [ miscellaneous, transformation, GCP ]
---

# m.transform

Computes a coordinate transformation based on the control points.

=== "Command line"

    **m.transform**
    [**-srx**]
    **group**=*name*
    **order**=*integer*
    [**format**=*string* [,*string*,...]]
    [**input**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    m.transform group=name order=1
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***m.transform***",
        **group**,
        **order**=*1*,
        **format**=*"fd,rd"*,
        **input**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("m.transform", group="name", order=1)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.m_transform*(**group**,
        **order**=*1*,
        **format**=*"fd,rd"*,
        **input**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.m_transform(group="name", order=1)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **order**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Rectification polynomial order  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **format**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *idx, src, dst, fwd, rev, fxy, rxy, fd, rd*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fd,rd*  
    &nbsp;&nbsp;&nbsp;&nbsp;**idx**: point index  
    &nbsp;&nbsp;&nbsp;&nbsp;**src**: source coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**dst**: destination coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**fwd**: forward coordinates (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rev**: reverse coordinates (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;**fxy**: forward coordinates difference (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rxy**: reverse coordinates difference (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;**fd**: forward error (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rd**: reverse error (source)  
    **input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing coordinates to transform ("-" to read from stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Local x,y coordinates to target east,north  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display summary information  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reverse transform of coords file or coeff. dump  
    &nbsp;&nbsp;&nbsp;&nbsp;Target east,north coordinates to local x,y  
    **-x**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display transform matrix coefficients  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **order** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rectification polynomial order  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **format** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *idx, src, dst, fwd, rev, fxy, rxy, fd, rd*  
    &nbsp;&nbsp;&nbsp;&nbsp;**idx**: point index  
    &nbsp;&nbsp;&nbsp;&nbsp;**src**: source coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**dst**: destination coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**fwd**: forward coordinates (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rev**: reverse coordinates (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;**fxy**: forward coordinates difference (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rxy**: reverse coordinates difference (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;**fd**: forward error (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rd**: reverse error (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fd,rd*  
    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing coordinates to transform ("-" to read from stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Local x,y coordinates to target east,north  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *r*, *x*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display summary information  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse transform of coords file or coeff. dump  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Target east,north coordinates to local x,y  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display transform matrix coefficients  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **order** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rectification polynomial order  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **format** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *idx, src, dst, fwd, rev, fxy, rxy, fd, rd*  
    &nbsp;&nbsp;&nbsp;&nbsp;**idx**: point index  
    &nbsp;&nbsp;&nbsp;&nbsp;**src**: source coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**dst**: destination coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**fwd**: forward coordinates (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rev**: reverse coordinates (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;**fxy**: forward coordinates difference (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rxy**: reverse coordinates difference (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;**fd**: forward error (destination)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rd**: reverse error (source)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fd,rd*  
    **input** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing coordinates to transform ("-" to read from stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Local x,y coordinates to target east,north  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *r*, *x*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display summary information  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse transform of coords file or coeff. dump  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Target east,north coordinates to local x,y  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display transform matrix coefficients  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*m.transform* is an utility to compute transformation based upon GCPs
and output error measurements.

If coordinates are given with the **input** file option or fed from
`stdin`, both the input and the output format is "x y" with one
coordinate pair per line. Reverse transform is performed with the **-r**
flag.

The **format** option determines how control points are printed out. A
summary on the control points can be printed with the **-s** flag. The
summary includes maximum deviation observed when transforming GCPs and
overall RMS. The **format** option is ignored when coordinates are given
with the **input** file option.

## NOTES

The transformations are:

order=1:

```sh
    e = [E0 E1][1]·[1]
        [E2  0][e] [n]

    n = [N0 N1][1]·[1]
        [N2  0][e] [n]
```

order=2:

```sh
    e = [E0 E1 E3][1 ] [1 ]
        [E2 E4  0][e ]·[n ]
        [E5  0  0][e²] [n²]

    n = [N0 N1 N3][1 ] [1 ]
        [N2 N4  0][e ]·[n ]
        [N5  0  0][e²] [n²]
```

order=3:

```sh
    e = [E0 E1 E3 E6][1 ] [1 ]
        [E2 E4 E7  0][e ]·[n ]
        [E5 E8  0  0][e²] [n²]
        [E9  0  0  0][e³] [n³]

    n = [N0 N1 N3 N6][1 ] [1 ]
        [N2 N4 N7  0][e ]·[n ]
        [N5 N8  0  0][e²] [n²]
        [N9  0  0  0][e³] [n³]
```

\["·" = dot-product, (AE)·N = N'EA\]

In other words, *order=1* and *order=2* are equivalent to *order=3* with
the higher coefficients equal to zero.

## SEE ALSO

*[i.ortho.transform](i.ortho.transform.md), [i.rectify](i.rectify.md),
[v.rectify](v.rectify.md), [v.transform](v.transform.md)*

## AUTHORS

Brian J. Buckley  
Glynn Clements  
Hamish Bowman

## SOURCE CODE

Available at: [m.transform source code](https://github.com/OSGeo/grass/tree/main/misc/m.transform)
([history](https://github.com/OSGeo/grass/commits/main/misc/m.transform))  
Latest change: Thursday Jul 24 04:25:59 2025 in commit [7882012](https://github.com/OSGeo/grass/commit/7882012b70873fbd1db9a7b3fe0a8e5175f477f5)
