---
title: Imagery tools
author: GRASS Development Team
---

# Imagery tools

To learn more about these tool in general, go to [Imagery introduction](imageryintro.md).

| Name | Description |
|--------|-------------|
| [i.albedo](i.albedo.md) | Computes broad band albedo from surface reflectance. |
| [i.aster.toar](i.aster.toar.md) | Calculates Top of Atmosphere Radiance/Reflectance/Brightness Temperature from ASTER DN. |
| [i.atcorr](i.atcorr.md) | Performs atmospheric correction using the 6S algorithm. 6S - Second Simulation of Satellite Signal in the Solar Spectrum. |
| [i.band.library](i.band.library.md) | Prints available semantic label information used for multispectral data. |
| [i.biomass](i.biomass.md) | Computes biomass growth, precursor of crop yield calculation. |
| [i.cca](i.cca.md) | Canonical components analysis (CCA) program for image processing. |
| [i.cluster](i.cluster.md) | Generates spectral signatures for land cover types in an image using a clustering algorithm. The resulting signature file is used as input for i.maxlik, to generate an unsupervised image classification. |
| [i.colors.enhance](i.colors.enhance.md) | Performs auto-balancing of colors for RGB images. |
| [i.eb.eta](i.eb.eta.md) | Actual evapotranspiration for diurnal period (Bastiaanssen, 1995). |
| [i.eb.evapfr](i.eb.evapfr.md) | Computes evaporative fraction and root zone soil moisture. |
| [i.eb.hsebal01](i.eb.hsebal01.md) | Computes sensible heat flux iteration SEBAL 01. |
| [i.eb.netrad](i.eb.netrad.md) | Net radiation approximation (Bastiaanssen, 1995). |
| [i.eb.soilheatflux](i.eb.soilheatflux.md) | Soil heat flux approximation (Bastiaanssen, 1995). |
| [i.emissivity](i.emissivity.md) | Computes emissivity from NDVI, generic method for sparse land. |
| [i.evapo.mh](i.evapo.mh.md) | Computes evapotranspiration calculation modified or original Hargreaves formulation, 2001. |
| [i.evapo.pm](i.evapo.pm.md) | Computes potential evapotranspiration calculation with hourly Penman-Monteith. |
| [i.evapo.pt](i.evapo.pt.md) | Computes evapotranspiration calculation Priestley and Taylor formulation, 1972. |
| [i.evapo.time](i.evapo.time.md) | Computes temporal integration of satellite ET actual (ETa) following the daily ET reference (ETo) from meteorological station(s). |
| [i.fft](i.fft.md) | Fast Fourier Transform (FFT) for image processing. |
| [i.gensig](i.gensig.md) | Generates statistics for i.maxlik from raster map. |
| [i.gensigset](i.gensigset.md) | Generates statistics for i.smap from raster map. |
| [i.group](i.group.md) | Creates, edits, and lists groups of imagery data. |
| [i.his.rgb](i.his.rgb.md) | Transforms raster maps from HIS (Hue-Intensity-Saturation) color space to RGB (Red-Green-Blue) color space. |
| [i.ifft](i.ifft.md) | Inverse Fast Fourier Transform (IFFT) for image processing. |
| [i.image.mosaic](i.image.mosaic.md) | Mosaics several images and extends colormap. |
| [i.in.spotvgt](i.in.spotvgt.md) | Imports SPOT VGT NDVI data into a raster map. |
| [i.landsat.acca](i.landsat.acca.md) | Performs Landsat TM/ETM+ Automatic Cloud Cover Assessment (ACCA). |
| [i.landsat.toar](i.landsat.toar.md) | Calculates top-of-atmosphere radiance or reflectance and temperature for Landsat MSS/TM/ETM+/OLI |
| [i.maxlik](i.maxlik.md) | Classifies the cell spectral reflectances in imagery data. Classification is based on the spectral signature information generated by either i.cluster, g.gui.iclass, or i.gensig. |
| [i.modis.qc](i.modis.qc.md) | Extracts quality control parameters from MODIS QC layers. |
| [i.oif](i.oif.md) | Calculates Optimum-Index-Factor table for spectral bands |
| [i.ortho.camera](i.ortho.camera.md) | Select and modify the imagery group camera reference file. |
| [i.ortho.elev](i.ortho.elev.md) | Select or modify the target elevation model. |
| [i.ortho.init](i.ortho.init.md) | Interactively creates or modifies entries in a camera initial exposure station file for imagery group referenced by a sub-block. |
| [i.ortho.photo](i.ortho.photo.md) | Menu driver for the photo imagery programs. |
| [i.ortho.rectify](i.ortho.rectify.md) | Orthorectifies an image by using the image to photo coordinate transformation matrix. |
| [i.ortho.target](i.ortho.target.md) | Select or modify the imagery group target. |
| [i.ortho.transform](i.ortho.transform.md) | Computes a coordinate transformation based on the control points. |
| [i.pansharpen](i.pansharpen.md) | Image fusion algorithms to sharpen multispectral with high-res panchromatic channels |
| [i.pca](i.pca.md) | Principal components analysis (PCA) for image processing. |
| [i.rectify](i.rectify.md) | Rectifies an image by computing a coordinate transformation for each pixel in the image based on the control points. |
| [i.rgb.his](i.rgb.his.md) | Transforms raster maps from RGB (Red-Green-Blue) color space to HIS (Hue-Intensity-Saturation) color space. |
| [i.segment](i.segment.md) | Identifies segments (objects) from imagery data. |
| [i.signatures](i.signatures.md) | Manage imagery classification signature files |
| [i.smap](i.smap.md) | Performs contextual image classification using sequential maximum a posteriori (SMAP) estimation. |
| [i.spectral](i.spectral.md) | Displays spectral response at user specified locations in group or images. |
| [i.target](i.target.md) | Targets an imagery group to a GRASS location and mapset. |
| [i.tasscap](i.tasscap.md) | Performs Tasseled Cap (Kauth Thomas) transformation. |
| [i.topo.corr](i.topo.corr.md) | Computes topographic correction of reflectance. |
| [i.vi](i.vi.md) | Calculates different types of vegetation indices. Uses red and nir bands mostly, and some indices require additional bands. |
| [i.zc](i.zc.md) | Zero-crossing "edge detection" raster function for image processing. |
